/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.fusesource.jansi.AnsiConsole;
import org.leadpony.justify.cli.ColorConsole;
import org.leadpony.justify.cli.Command;
import org.leadpony.justify.cli.CommandException;
import org.leadpony.justify.cli.Console;
import org.leadpony.justify.cli.Help;
import org.leadpony.justify.cli.Status;
import org.leadpony.justify.cli.Validate;

public class Launcher {
    public static final String PROPERTY_USE_JANSI = "org.leadpony.justify.cli.use.jansi";

    public Status launch(String[] args) {
        return this.launch(new LinkedList<String>(Arrays.asList(args)));
    }

    private Status launch(List<String> args) {
        Console console = Launcher.createConsole(args);
        try {
            Command command = Launcher.createCommand(args, console);
            return command.execute(args);
        }
        catch (CommandException e) {
            console.withColor(Console.Color.DANGER).error(e);
            return Status.FAILED;
        }
        catch (Exception e) {
            console.withColor(Console.Color.DANGER).error(e);
            return Status.FAILED;
        }
    }

    private static Console createConsole(List<String> args) {
        String useJansi = System.getProperty(PROPERTY_USE_JANSI, "true");
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        if (useJansi.equals("true")) {
            stdout = AnsiConsole.out();
            stderr = AnsiConsole.err();
        }
        return new ColorConsole(stdout, stderr);
    }

    private static Command createCommand(List<String> args, Console console) {
        if (args.isEmpty() || args.contains("-h")) {
            return new Help(console);
        }
        return new Validate(console);
    }

    public static void main(String[] args) {
        System.exit(new Launcher().launch(args).code());
    }
}

