/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.leadpony.justify.cli.Location;

class LocalLocation
implements Location {
    private final Path path;

    LocalLocation(Path path) {
        this.path = path;
    }

    @Override
    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public Location resolve(Location other) {
        if (other instanceof LocalLocation) {
            Path otherPath = ((LocalLocation)other).path();
            if (otherPath.isAbsolute()) {
                return other;
            }
            Path parent = this.path.getParent();
            if (parent == null) {
                return other;
            }
            Path resolved = parent.resolve(otherPath);
            return new LocalLocation(resolved);
        }
        return other;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.path.toUri().toURL();
    }

    public Path path() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }
}

