/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.leadpony.justify.cli.LocalLocation;
import org.leadpony.justify.cli.Location;

class RemoteLocation
implements Location {
    public static final Pattern URL_PATTERN = Pattern.compile("^(https?|file|jar):");
    private final URL url;

    RemoteLocation(URL url) {
        this.url = url;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public Location resolve(Location other) {
        if (other instanceof LocalLocation) {
            Path otherPath = ((LocalLocation)other).path();
            if (otherPath.isAbsolute()) {
                return other;
            }
            try {
                URL resolved = this.url.toURI().resolve(otherPath.toString()).toURL();
                return new RemoteLocation(resolved);
            }
            catch (MalformedURLException | URISyntaxException e) {
                return other;
            }
        }
        return other;
    }

    @Override
    public URL toURL() {
        return this.url;
    }

    public String toString() {
        return this.url.toString();
    }
}

