/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TypeNode {
    private final String fieldName;
    private final String typeName;
    private final String template;
    private final boolean mappedType;
    private final List<TypeNode> children;

    public TypeNode() {
        this.fieldName = "FieldName";
        this.template = "/org/leandreck/endpoints/templates/typescript/interface.ftl";
        this.children = new ArrayList<TypeNode>(10);
        this.typeName = "SimpleType";
        this.mappedType = false;
    }

    public TypeNode(String fieldName, String typeName) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.template = "";
        this.children = Collections.emptyList();
        this.mappedType = true;
    }

    public TypeNode(String fieldName, String typeName, String template, List<TypeNode> children) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.template = template;
        this.children = children;
        this.mappedType = false;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTemplate() {
        return this.template;
    }

    List<TypeNode> getRealChildren() {
        return this.children;
    }

    public List<TypeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeNode typeNode = (TypeNode)o;
        return this.typeName.equals(typeNode.typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public boolean isMappedType() {
        return this.mappedType;
    }
}

