/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.printer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.leandreck.endpoints.processor.model.EndpointNode;
import org.leandreck.endpoints.processor.model.TypeNode;

public class Engine {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);

    public Engine() {
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setClassForTemplateLoading(this.getClass(), "/");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
    }

    public void processEndpoint(EndpointNode clazz, Set<TypeNode> types, Writer out) throws IOException, TemplateException {
        Template imports = this.cfg.getTemplate("/org/leandreck/endpoints/templates/typescript/imports.ftl");
        HashMap<String, Set<TypeNode>> root = new HashMap<String, Set<TypeNode>>();
        root.put("types", types);
        imports.process(root, out);
        Template service = this.cfg.getTemplate(clazz.getTemplate());
        service.process((Object)clazz, out);
        out.append("\n");
    }

    public void processTypeScriptTypeNode(TypeNode node, Writer out) throws IOException, TemplateException {
        Template temp = this.cfg.getTemplate(node.getTemplate());
        temp.process((Object)node, out);
        out.append("\n");
    }
}

