/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptEndpoint;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EndpointNode;
import org.leandreck.endpoints.processor.model.MethodNode;
import org.leandreck.endpoints.processor.model.MethodNodeFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public class EndpointNodeFactory {
    private final MethodNodeFactory methodNodeFactory;
    private final TemplateConfiguration configuration;

    public EndpointNodeFactory(TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        this.configuration = configuration;
        this.methodNodeFactory = new MethodNodeFactory(configuration, typeUtils, elementUtils);
    }

    public EndpointNode createEndpointNode(TypeElement typeElement) {
        TypeScriptEndpoint annotation = typeElement.getAnnotation(TypeScriptEndpoint.class);
        String name = EndpointNodeFactory.defineName(typeElement, annotation);
        String url = EndpointNodeFactory.defineUrl(typeElement);
        String template = this.defineTemplate(annotation);
        List<MethodNode> methods = this.defineMethods(typeElement);
        return new EndpointNode(name, url, template, methods);
    }

    private List<MethodNode> defineMethods(TypeElement typeElement) {
        return ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().map(this.methodNodeFactory::createMethodNode).filter(method -> !method.isIgnored()).collect(Collectors.toList());
    }

    private static String defineName(TypeElement typeElement, TypeScriptEndpoint annotation) {
        String name = annotation.value().isEmpty() ? typeElement.getSimpleName().toString() : annotation.value();
        return name;
    }

    private static String defineUrl(TypeElement typeElement) {
        String[] mappings;
        RequestMapping requestMapping = typeElement.getAnnotation(RequestMapping.class);
        if (requestMapping != null && (mappings = requestMapping.value()).length > 0) {
            return mappings[0];
        }
        return "";
    }

    private String defineTemplate(TypeScriptEndpoint annotation) {
        String template = annotation == null || annotation.template().isEmpty() ? this.configuration.getEndpointTemplate() : annotation.template();
        return template;
    }
}

