/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;

public abstract class TypeNode {
    private final boolean optional;

    protected TypeNode(boolean optional) {
        this.optional = optional;
    }

    public abstract TypeNodeKind getKind();

    public abstract String getFieldName();

    public abstract String getParameterName();

    public String getAsFunctionParameter() {
        String functionParameter = this.getParameterName() == null ? this.getFieldName() : this.getParameterName();
        return this.isOptional() ? functionParameter + '?' : functionParameter;
    }

    public String getAsVariableName() {
        return this.getParameterName() == null ? this.getFieldName() : this.getParameterName();
    }

    public abstract String getTypeName();

    public String getTypeNameVariable() {
        return this.getType();
    }

    public abstract String getType();

    public String getVariableType() {
        return this.getTypeName();
    }

    public abstract String getTemplate();

    public abstract List<TypeNode> getTypeParameters();

    public abstract List<TypeNode> getChildren();

    public abstract Set<TypeNode> getTypes();

    public abstract Set<TypeNode> getImports();

    public Set<EnumValue> getEnumValues() {
        return Collections.emptySet();
    }

    public boolean isMappedType() {
        return false;
    }

    public boolean isDeclaredComplexType() {
        return !this.isMappedType() && TypeNodeKind.MAP != this.getKind();
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeNode typeNode = (TypeNode)o;
        return this.getTypeName().equals(typeNode.getTypeName());
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }
}

