/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.config;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import org.leandreck.endpoints.annotations.TypeScriptTemplatesConfiguration;
import org.leandreck.endpoints.processor.config.MultipleConfigurationsFoundException;
import org.leandreck.endpoints.processor.model.PrintConfiguration;
import org.leandreck.endpoints.processor.model.StringUtil;

public class TemplateConfiguration {
    private final String apiModuleTemplate;
    private final String endpointTemplate;
    private final String enumerationTemplate;
    private final String indexTemplate;
    private final String interfaceTemplate;
    private final PrintConfiguration globalPrintConfiguration;

    private TemplateConfiguration(String apiModuleTemplate, String enumerationTemplate, String indexTemplate, String interfaceTemplate, String endpointTemplate, PrintConfiguration globalPrintConfiguration) {
        this.apiModuleTemplate = apiModuleTemplate;
        this.enumerationTemplate = enumerationTemplate;
        this.indexTemplate = indexTemplate;
        this.interfaceTemplate = interfaceTemplate;
        this.endpointTemplate = endpointTemplate;
        this.globalPrintConfiguration = globalPrintConfiguration;
    }

    public static TemplateConfiguration buildFromEnvironment(RoundEnvironment roundEnv) throws MultipleConfigurationsFoundException {
        Set<? extends Element> configurationAnnotation = roundEnv.getElementsAnnotatedWith(TypeScriptTemplatesConfiguration.class);
        if (configurationAnnotation != null && configurationAnnotation.size() > 1) {
            throw new MultipleConfigurationsFoundException(configurationAnnotation);
        }
        if (configurationAnnotation == null || configurationAnnotation.isEmpty()) {
            return TemplateConfiguration.createDefaultTemplateConfiguration();
        }
        TypeScriptTemplatesConfiguration annotation = configurationAnnotation.iterator().next().getAnnotation(TypeScriptTemplatesConfiguration.class);
        return new TemplateConfiguration(StringUtil.definedValue(annotation.apimodule(), "/org/leandreck/endpoints/templates/typescript/apimodule.ftl"), StringUtil.definedValue(annotation.enumeration(), "/org/leandreck/endpoints/templates/typescript/enum.ftl"), StringUtil.definedValue(annotation.index(), "/org/leandreck/endpoints/templates/typescript/index.ftl"), StringUtil.definedValue(annotation.interfaces(), "/org/leandreck/endpoints/templates/typescript/interface.ftl"), StringUtil.definedValue(annotation.endpoint(), "/org/leandreck/endpoints/templates/typescript/service.ftl"), new PrintConfiguration(annotation.useSuffixes(), StringUtil.definedValue(annotation.suffixGet(), "Get"), StringUtil.definedValue(annotation.suffixHead(), "Head"), StringUtil.definedValue(annotation.suffixDelete(), "Delete"), StringUtil.definedValue(annotation.suffixOptions(), "Options"), StringUtil.definedValue(annotation.suffixPatch(), "Patch"), StringUtil.definedValue(annotation.suffixPost(), "Post"), StringUtil.definedValue(annotation.suffixPut(), "Put"), StringUtil.definedValue(annotation.suffixTrace(), "Trace")));
    }

    public String getEnumTemplate() {
        return this.enumerationTemplate;
    }

    public String getInterfaceTemplate() {
        return this.interfaceTemplate;
    }

    public String getEndpointTemplate() {
        return this.endpointTemplate;
    }

    public String getIndexTemplate() {
        return this.indexTemplate;
    }

    public String getApiModuleTemplate() {
        return this.apiModuleTemplate;
    }

    public PrintConfiguration getGlobalPrintConfiguration() {
        return this.globalPrintConfiguration;
    }

    private static TemplateConfiguration createDefaultTemplateConfiguration() {
        return new TemplateConfiguration("/org/leandreck/endpoints/templates/typescript/apimodule.ftl", "/org/leandreck/endpoints/templates/typescript/enum.ftl", "/org/leandreck/endpoints/templates/typescript/index.ftl", "/org/leandreck/endpoints/templates/typescript/interface.ftl", "/org/leandreck/endpoints/templates/typescript/service.ftl", TemplateConfiguration.createDefaultPrintConfiguration());
    }

    private static PrintConfiguration createDefaultPrintConfiguration() {
        return new PrintConfiguration(true, "Get", "Head", "Delete", "Options", "Patch", "Post", "Put", "Trace");
    }
}

