/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.leandreck.endpoints.processor.model.MethodNode;
import org.leandreck.endpoints.processor.model.PrintConfiguration;
import org.leandreck.endpoints.processor.model.TypeNode;

public class EndpointNode {
    private final String serviceName;
    private final String serviceURL;
    private final String template;
    private final List<MethodNode> methods;
    private final List<MethodNode> getMethods;
    private final List<MethodNode> headMethods;
    private final List<MethodNode> postMethods;
    private final List<MethodNode> putMethods;
    private final List<MethodNode> patchMethods;
    private final List<MethodNode> deleteMethods;
    private final List<MethodNode> optionsMethods;
    private final List<MethodNode> traceMethods;
    private final Set<TypeNode> types;
    private final PrintConfiguration printConfiguration;

    EndpointNode(String serviceName, String serviceURL, String template, List<MethodNode> methods, PrintConfiguration printConfiguration) {
        this.serviceName = serviceName;
        this.serviceURL = serviceURL;
        this.template = template;
        this.methods = methods;
        this.printConfiguration = printConfiguration;
        this.getMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("get")).collect(Collectors.toList());
        this.headMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("head")).collect(Collectors.toList());
        this.postMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("post")).collect(Collectors.toList());
        this.putMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("put")).collect(Collectors.toList());
        this.patchMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("patch")).collect(Collectors.toList());
        this.deleteMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("delete")).collect(Collectors.toList());
        this.optionsMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("options")).collect(Collectors.toList());
        this.traceMethods = this.getMethods().stream().filter(m -> m.getHttpMethods().contains("trace")).collect(Collectors.toList());
        this.types = this.collectTypes();
    }

    private Set<TypeNode> collectTypes() {
        HashMap typeMap = new HashMap();
        this.getMethods().stream().map(MethodNode::getTypes).flatMap(Collection::stream).filter(TypeNode::isDeclaredComplexType).forEach(type -> typeMap.put(type.getTypeName(), type));
        return new HashSet<TypeNode>(typeMap.values());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public String getTemplate() {
        return this.template;
    }

    public Set<TypeNode> getTypes() {
        return this.types;
    }

    public List<MethodNode> getGetMethods() {
        return this.getMethods;
    }

    public List<MethodNode> getHeadMethods() {
        return this.headMethods;
    }

    public List<MethodNode> getPostMethods() {
        return this.postMethods;
    }

    public List<MethodNode> getTraceMethods() {
        return this.traceMethods;
    }

    public List<MethodNode> getOptionsMethods() {
        return this.optionsMethods;
    }

    public List<MethodNode> getDeleteMethods() {
        return this.deleteMethods;
    }

    public List<MethodNode> getPatchMethods() {
        return this.patchMethods;
    }

    public List<MethodNode> getPutMethods() {
        return this.putMethods;
    }

    public PrintConfiguration getPrintConfiguration() {
        return this.printConfiguration;
    }
}

