/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.processor.config.TemplateConfiguration;
import org.leandreck.endpoints.processor.model.EnumValue;
import org.leandreck.endpoints.processor.model.InitTypeNodeFactoriesException;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.UnkownTypeProcessingException;
import org.leandreck.endpoints.processor.model.VariableAnnotations;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeKind;
import org.leandreck.endpoints.processor.model.typefactories.TypeNodeUtils;

public final class TypeNodeFactory {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TemplateConfiguration configuration;
    private final Map<TypeNodeKind, ConcreteTypeNodeFactory> factories;
    private final Map<String, TypeNode> nodes;

    TypeNodeFactory(TemplateConfiguration configuration, Types typeUtils, Elements elementUtils) {
        this.configuration = configuration;
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.factories = this.initFactories();
        this.nodes = new HashMap<String, TypeNode>(100);
    }

    private Map<TypeNodeKind, ConcreteTypeNodeFactory> initFactories() {
        EnumMap<TypeNodeKind, ConcreteTypeNodeFactory> tmpFactories = new EnumMap<TypeNodeKind, ConcreteTypeNodeFactory>(TypeNodeKind.class);
        Arrays.stream(TypeNodeKind.values()).forEach(it -> {
            try {
                tmpFactories.put((TypeNodeKind)((Object)it), it.getTypeNodeFactory().newConfiguredInstance(this, this.configuration, this.typeUtils, this.elementUtils));
            }
            catch (Exception e) {
                throw new InitTypeNodeFactoriesException(e);
            }
        });
        return tmpFactories;
    }

    public TypeNode createTypeNode(TypeMirror typeMirror) {
        return this.createTypeNode(typeMirror, null);
    }

    public TypeNode createTypeNode(TypeMirror typeMirror, DeclaredType containingType) {
        String fieldName = "TYPE-ROOT";
        return this.initType("TYPE-ROOT", null, false, this.defineKind(typeMirror), typeMirror, containingType);
    }

    public TypeNode createTypeNode(String fieldName, String parameterName, TypeMirror typeMirror, DeclaredType containingType) {
        return this.initType(fieldName, parameterName, false, this.defineKind(typeMirror), typeMirror, containingType);
    }

    TypeNode createTypeNode(VariableElement variableElement, String parameterName, DeclaredType containingType) {
        TypeMirror typeMirror = variableElement.asType();
        String fieldName = variableElement.getSimpleName().toString();
        TypeNodeKind typeNodeKind = this.defineKind(typeMirror);
        boolean optionalByAnnotation = VariableAnnotations.isOptionalByAnnotation(variableElement);
        boolean optionalByType = TypeNodeKind.OPTIONAL.equals((Object)typeNodeKind);
        return this.initType(fieldName, parameterName, optionalByAnnotation || optionalByType, typeNodeKind, typeMirror, containingType);
    }

    public List<TypeNode> defineChildren(TypeElement typeElement, DeclaredType typeMirror) {
        List<String> publicGetter = TypeNodeFactory.definePublicGetter(typeElement, typeMirror, this.typeUtils);
        return ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(c -> c.getAnnotation(TypeScriptIgnore.class) == null).filter(c -> !c.getModifiers().contains((Object)Modifier.TRANSIENT)).filter(c -> this.filterVariableElements((VariableElement)c, publicGetter)).map(it -> this.createTypeNode((VariableElement)it, null, typeMirror)).collect(Collectors.toList());
    }

    private static List<String> definePublicGetter(TypeElement typeElement, TypeMirror typeMirror, Types typeUtils) {
        List<String> publicGetters = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(g -> g.getSimpleName().toString().startsWith("get") || g.getSimpleName().toString().startsWith("is")).filter(g -> g.getModifiers().contains((Object)Modifier.PUBLIC)).filter(g -> !g.getModifiers().contains((Object)Modifier.ABSTRACT)).map(g -> g.getSimpleName().toString()).collect(Collectors.toList());
        if (TypeNodeFactory.isLombokAnnotatedType(typeMirror, typeUtils)) {
            ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(g -> !g.getModifiers().contains((Object)Modifier.STATIC)).map(g -> g.getSimpleName().toString()).forEach(publicGetters::add);
        }
        return publicGetters;
    }

    private static boolean isLombokAnnotatedType(TypeMirror typeMirror, Types typeUtils) {
        return Arrays.stream(new String[]{"lombok.Data", "lombok.Value", "lombok.Getter"}).anyMatch(annotationName -> {
            try {
                Class<?> dataAnnotationClass = Class.forName(annotationName);
                Object dataAnnotation = TypeNodeUtils.getAnnotationForClass(typeMirror, dataAnnotationClass, typeUtils);
                return dataAnnotation != null;
            }
            catch (Exception exception) {
                return false;
            }
        });
    }

    private boolean filterVariableElements(VariableElement variableElement, List<String> publicGetter) {
        return publicGetter.stream().map(g -> g.toLowerCase(Locale.ENGLISH).endsWith(variableElement.getSimpleName().toString().toLowerCase(Locale.ENGLISH))).reduce(false, (a, b) -> a != false || b != false);
    }

    private TypeNode initType(String fieldName, String parameterName, boolean optional, TypeNodeKind typeNodeKind, TypeMirror typeMirror, DeclaredType containingType) {
        String key = typeMirror.toString();
        if (this.nodes.containsKey(key) && !TypeKind.TYPEVAR.equals((Object)typeMirror.getKind())) {
            ProxyNode proxyNode = new ProxyNode(fieldName, parameterName, optional);
            proxyNode.setNode(this.nodes.get(key));
            return proxyNode;
        }
        try {
            ProxyNode proxyNode = new ProxyNode(fieldName, parameterName, optional);
            this.nodes.put(key, proxyNode);
            ConcreteTypeNodeFactory nodeFactory = this.factories.get((Object)typeNodeKind);
            TypeNode newTypeNode = nodeFactory.createTypeNode(fieldName, parameterName, optional, typeMirror, containingType);
            proxyNode.setNode(newTypeNode);
            this.nodes.put(key, newTypeNode);
            return newTypeNode;
        }
        catch (Exception e) {
            throw new UnkownTypeProcessingException(e);
        }
    }

    private TypeNodeKind defineKind(TypeMirror typeMirror) {
        TypeNodeKind typeNodeKind;
        if (typeMirror == null) {
            return TypeNodeKind.NULL;
        }
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case ARRAY: {
                typeNodeKind = TypeNodeKind.ARRAY;
                break;
            }
            case TYPEVAR: {
                typeNodeKind = TypeNodeKind.TYPEVAR;
                break;
            }
            case DECLARED: {
                typeNodeKind = this.defineDeclaredTypeNodeKind(typeMirror);
                break;
            }
            default: {
                typeNodeKind = TypeNodeKind.containsMapping(kind.name()) ? TypeNodeKind.MAPPED : TypeNodeKind.SIMPLE;
            }
        }
        return typeNodeKind;
    }

    private TypeNodeKind defineDeclaredTypeNodeKind(TypeMirror typeMirror) {
        DeclaredType declaredType;
        ElementKind elementKind = this.typeUtils.asElement(typeMirror).getKind();
        TypeMirror collectionMirror = this.elementUtils.getTypeElement("java.util.Collection").asType();
        DeclaredType mapMirror = this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement("java.util.Map"), new TypeMirror[0]);
        TypeNodeKind typeNodeKind = ElementKind.ENUM.equals((Object)elementKind) ? TypeNodeKind.ENUM : (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(collectionMirror)) ? TypeNodeKind.COLLECTION : (this.typeUtils.isAssignable(typeMirror, this.typeUtils.erasure(mapMirror)) ? TypeNodeKind.MAP : (TypeNodeKind.containsMapping((declaredType = (DeclaredType)typeMirror).asElement().getSimpleName().toString()) ? TypeNodeKind.MAPPED : (declaredType.asElement().asType().toString().equals("java.util.Optional<T>") || declaredType.asElement().asType().toString().equals("org.springframework.http.ResponseEntity<T>") ? TypeNodeKind.OPTIONAL : TypeNodeKind.SIMPLE))));
        return typeNodeKind;
    }

    class ProxyNode
    extends TypeNode {
        private TypeNode delegate;
        private final String fieldName;
        private final String parameterName;

        private ProxyNode(String fieldName, String parameterName, boolean optional) {
            super(optional);
            this.fieldName = fieldName;
            this.parameterName = parameterName;
        }

        private void setNode(TypeNode delegate) {
            this.delegate = delegate;
        }

        @Override
        public TypeNodeKind getKind() {
            return this.delegate.getKind();
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }

        @Override
        public String getTypeName() {
            return this.delegate.getTypeName();
        }

        @Override
        public String getTypeNameVariable() {
            return this.delegate.getTypeNameVariable();
        }

        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public String getVariableType() {
            return this.delegate.getVariableType();
        }

        @Override
        public String getTemplate() {
            return this.delegate.getTemplate();
        }

        @Override
        public List<TypeNode> getTypeParameters() {
            return this.delegate.getTypeParameters();
        }

        @Override
        public List<TypeNode> getChildren() {
            return this.delegate.getChildren();
        }

        @Override
        public Set<TypeNode> getTypes() {
            return this.delegate.getTypes();
        }

        @Override
        public Set<TypeNode> getImports() {
            return this.delegate.getImports();
        }

        @Override
        public Set<EnumValue> getEnumValues() {
            return this.delegate.getEnumValues();
        }

        @Override
        public boolean isMappedType() {
            return this.delegate.isMappedType();
        }

        @Override
        public boolean isDeclaredComplexType() {
            return this.delegate.isDeclaredComplexType();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

