/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model.typefactories;

import java.util.HashMap;
import java.util.Map;
import org.leandreck.endpoints.processor.model.InitTypeNodeFactoriesException;
import org.leandreck.endpoints.processor.model.typefactories.ArrayTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.CollectionTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.ConcreteTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.EnumTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.MapTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.MappedTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.NullTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.OptionalTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.SimpleTypeNodeFactory;
import org.leandreck.endpoints.processor.model.typefactories.TypeVarTypeNodeFactory;

public enum TypeNodeKind {
    SIMPLE(SimpleTypeNodeFactory.class),
    ARRAY(ArrayTypeNodeFactory.class),
    COLLECTION(CollectionTypeNodeFactory.class),
    MAP(MapTypeNodeFactory.class),
    ENUM(EnumTypeNodeFactory.class),
    MAPPED(MappedTypeNodeFactory.class),
    OPTIONAL(OptionalTypeNodeFactory.class),
    TYPEVAR(TypeVarTypeNodeFactory.class),
    NULL(NullTypeNodeFactory.class);

    private static final String NUMBER_TYPE = "number";
    private static final String STRING_TYPE = "string";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final Map<String, String> mappings;
    private final ConcreteTypeNodeFactory typeNodeFactory;

    private TypeNodeKind(Class<? extends ConcreteTypeNodeFactory> typeNodeFactory) {
        ConcreteTypeNodeFactory tmpFactory = null;
        try {
            tmpFactory = typeNodeFactory.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InitTypeNodeFactoriesException(e);
        }
        this.typeNodeFactory = tmpFactory;
    }

    public ConcreteTypeNodeFactory getTypeNodeFactory() {
        return this.typeNodeFactory;
    }

    public static boolean containsMapping(String key) {
        return mappings.containsKey(key);
    }

    public static String getMapping(String key) {
        return mappings.get(key);
    }

    static {
        mappings = new HashMap<String, String>(20);
        mappings.put("VOID", "void");
        mappings.put("BYTE", NUMBER_TYPE);
        mappings.put("Byte", NUMBER_TYPE);
        mappings.put("SHORT", NUMBER_TYPE);
        mappings.put("Short", NUMBER_TYPE);
        mappings.put("INT", NUMBER_TYPE);
        mappings.put("Integer", NUMBER_TYPE);
        mappings.put("LONG", NUMBER_TYPE);
        mappings.put("Long", NUMBER_TYPE);
        mappings.put("FLOAT", NUMBER_TYPE);
        mappings.put("Float", NUMBER_TYPE);
        mappings.put("DOUBLE", NUMBER_TYPE);
        mappings.put("Double", NUMBER_TYPE);
        mappings.put("BigDecimal", NUMBER_TYPE);
        mappings.put("BigInteger", NUMBER_TYPE);
        mappings.put("CHAR", STRING_TYPE);
        mappings.put("Character", STRING_TYPE);
        mappings.put("String", STRING_TYPE);
        mappings.put("BOOLEAN", BOOLEAN_TYPE);
        mappings.put("Boolean", BOOLEAN_TYPE);
        mappings.put("Date", "Date");
        mappings.put("LocalDate", "Date");
        mappings.put("Object", "any");
        mappings.put("MultipartFile", "FormData");
    }
}

