import { IRootType } from './IRootType.model';
import { MyTypeScriptType } from './MyTypeScriptType.model';
import { ISubType } from './ISubType.model';
import { Injectable } from '@angular/core';
import { Http, Response } from '@angular/http';

@Injectable()
export class TestTypeScriptEndpoint {

    private serviceBaseURL = '/api'

    constructor(private _http: Http) { }

    get_getPersons(): IRootType[] {
    return this._http.get(this.serviceBaseURL + '/persons')
        .map((res: Response) => res.json())
        .catch(this.handleError);
    }

    get_getPerson(): IRootType {
    return this._http.get(this.serviceBaseURL + '/person/{id}')
        .map((res: Response) => res.json())
        .catch(this.handleError);
    }

    post_updatePerson(): IRootType {
    return this._http.post(this.serviceBaseURL + '/person/{id}')
        .map((res: Response) => res.json())
        .catch(this.handleError);
    }

    get_maps(): { [index: IString]: IRootType } {
    return this._http.get(this.serviceBaseURL + '/maps')
        .map((res: Response) => res.json())
        .catch(this.handleError);
    }


    private handleError(error: Response) {
        // in a real world app, we may send the error to some remote logging infrastructure
        // instead of just logging it to the console
        console.error(error);
    }
}



