import { IRootType } from './IRootType.model';
import { MyTypeScriptType } from './MyTypeScriptType.model';
import { ISubType } from './ISubType.model';

import { Http, Response, RequestOptions, Headers, RequestOptionsArgs } from "@angular/http";
import { Injectable } from '@angular/core';

import { Observable } from "rxjs/Observable";
import { ErrorObservable } from "rxjs/observable/ErrorObservable";
import "rxjs/add/operator/do";
import "rxjs/add/operator/catch";
import "rxjs/add/observable/throw";

@Injectable()
export class TestTypeScriptEndpoint {
    private serviceBaseURL = '/api'
    constructor(private http: Http) { }
    /* GET */
    public getPersonsGet(): Observable<IRootType[]> {
        let url = this.serviceBaseURL + '/persons';

        return this.httpGet(url)
            .map((response: Response) => <IRootType[]>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    public getPersonGet(id: number, typeRef: string): Observable<MyTypeScriptType> {
        let url = this.serviceBaseURL + '/person/' + id + '/' + typeRef + '';

        return this.httpGet(url)
            .map((response: Response) => <MyTypeScriptType>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    public mapsGet(): Observable<{ [index: string]: MyTypeScriptType }> {
        let url = this.serviceBaseURL + '/maps';

        return this.httpGet(url)
            .map((response: Response) => <{ [index: string]: MyTypeScriptType }>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    private httpGet(url: string): Observable<Response> {
        console.info('httpGet: ' + serviceUrl);
        return this.http.get(url);
    }

    /* HEAD */
    public handleSubTypeHead(): Observable<Response> {
        let url = this.serviceBaseURL + '/subType';
        return this.httpHead(url)
            .catch((error: Response) => this.handleError(error));
    }

    private httpHead(url: string): Observable<Response> {
        console.info('httpHead: ' + url);
        return this.http.head(url);
    }

    /* POST */
    public setIdPost(id: number, body: ISubType): Observable<ISubType[]> {
        let url = this.serviceBaseURL + '/type/' + id + '/' + typeRef + '';
        return this.httpPost(url, body)
            .map((response: Response) => <ISubType[]>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    public updatePersonPost(id: number, rootType: MyTypeScriptType): Observable<MyTypeScriptType> {
        let url = this.serviceBaseURL + '/person/' + id + '';
        return this.httpPost(url, rootType)
            .map((response: Response) => <MyTypeScriptType>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    private httpPost(url: string, body: any): Observable<Response> {
        console.info('httpPost: ' + url);
        return this.http.post(url, body);
    }

    /* PUT */
    public handleSubTypePut(param: ISubType): Observable<ISubType> {
        let url = this.serviceBaseURL + '/subType';
        return this.httpPut(url, param)
            .map((response: Response) => <ISubType>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    private httpPut(url: string, body: any): Observable<Response> {
        console.info('httpPut: ' + url);
        return this.http.put(url, body);
    }

    /* PATCH */
    public handleSubTypePatch(param: ISubType): Observable<ISubType> {
        let url = this.serviceBaseURL + '/subType';
        return this.httpPatch(url, param)
            .map((response: Response) => <ISubType>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    private httpPatch(url: string, body: any): Observable<Response> {
        console.info('httpPatch: ' + url);
        return this.http.patch(url, body);
    }

    /* DELETE */
    public handleSubTypeDelete(): Observable<Response> {
        let url = this.serviceBaseURL + '/subType';
        return this.httpDelete(url)
          .catch((error: Response) => this.handleError(error));
    }

    private httpDelete(url: string): Observable<Response> {
        console.info('httpDelete: ' + url);
        return this.http.delete(url);
    }

    /* OPTIONS */
    public handleSubTypeOptions(param: ISubType): Observable<Response> {
        let url = this.serviceBaseURL + '/subType';
        return this.httpOptions(url)
            .catch((error: Response) => this.handleError(error));
    }

    private httpOptions(url: string, body: any): Observable<Response> {
        console.info('httpOptions: ' + url);
        return this.http.options(url, body);
    }

    /* TRACE */
    public handleSubTypeTrace(param: ISubType): Observable<ISubType> {
        let url = this.serviceBaseURL + '/subType';
        return this.httpTrace(url, param)
            .map((response: Response) => <ISubType>response.json())
            .catch((error: Response) => this.handleError(error));
    }

    private httpTrace(url: string, body: any): Observable<Response> {
        console.info('httpTrace: ' + url);
        return this.http.trace(url, body);
    }

    private handleError(error: Response) {
        // in a real world app, we may send the error to some remote logging infrastructure
        // instead of just logging it to the console
        console.error(error);
    }

}

