/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.examples;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.leandreck.endpoints.examples.RootType;
import org.leandreck.endpoints.examples.SubType;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class TestTypeScriptEndpoint {
    @RequestMapping(value={"/type/{id}/{typeRef}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public List<SubType> setId(@PathVariable Long id, @RequestBody SubType body) {
        return Collections.singletonList(body);
    }

    @RequestMapping(value={"/persons"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<RootType> getPersons() {
        ArrayList<RootType> rootTypes = new ArrayList<RootType>();
        rootTypes.add(new RootType());
        return rootTypes;
    }

    @RequestMapping(value={"/person/{id}/{typeRef}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RootType getPerson(@PathVariable Long id, @PathVariable String typeRef) {
        return new RootType(id);
    }

    @RequestMapping(value={"/person/{id}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public RootType updatePerson(@PathVariable Long id, @RequestBody RootType rootType) {
        rootType.setId(id);
        return rootType;
    }

    @RequestMapping(value={"/maps"}, method={RequestMethod.GET}, consumes={"application/json"}, produces={"application/json"})
    public Map<String, RootType> maps() {
        HashMap<String, RootType> map = new HashMap<String, RootType>();
        map.put("one", new RootType());
        return map;
    }

    @RequestMapping(value={"/photos/{id}"}, method={RequestMethod.GET}, produces={"image/png"})
    public ResponseEntity<InputStreamResource> getPhoto(@PathVariable Long id) {
        return ResponseEntity.ok().contentLength(0L).contentType(MediaType.IMAGE_PNG).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream("No Content".getBytes())));
    }

    private List<RootType> ignoreList() {
        return null;
    }

    protected List<RootType> ignoredTwo() {
        return null;
    }

    List<RootType> ignoredAlso() {
        return null;
    }

    @RequestMapping(value={"/subType"}, method={RequestMethod.HEAD, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS, RequestMethod.TRACE}, produces={"application/json"})
    public SubType handleSubType(@RequestBody SubType param) {
        return param;
    }
}

