import { SubType } from './subtype.model.generated';
import { RootType } from './roottype.model.generated';
import { SimpleEnum } from './simpleenum.model.generated';
import { MapValueType } from './mapvaluetype.model.generated';
import { MapKeyType } from './mapkeytype.model.generated';
import { MyTypeScriptType } from './mytypescripttype.model.generated';

import { HttpClient, HttpParams, HttpRequest } from '@angular/common/http';
import { Injectable } from '@angular/core';

import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/observable/throw';
import 'rxjs/add/operator/map';

@Injectable()
export class SecondTypeScriptEndpoint {
    private serviceBaseURL = '/api';
    constructor(private httpClient: HttpClient) { }
    /* GET */
    public getPersonsGet(): Observable<RootType[]> {
        const url = this.serviceBaseURL + '/persons';
        const params = new HttpParams();
        return this.httpClient.get<RootType[]>(url, {params: params})
            .catch((error: Response) => this.handleError(error));
    }

    public getPersonGet(id: number, typeRef: string): Observable<MyTypeScriptType> {
        const url = this.serviceBaseURL + '/person/' + id + '/' + typeRef + '';
        const params = new HttpParams();
        return this.httpClient.get<MyTypeScriptType>(url, {params: params})
            .catch((error: Response) => this.handleError(error));
    }

    public mapsGet(): Observable<{ [index: string]: MyTypeScriptType }> {
        const url = this.serviceBaseURL + '/maps';
        const params = new HttpParams();
        return this.httpClient.get<{ [index: string]: MyTypeScriptType }>(url, {params: params})
            .catch((error: Response) => this.handleError(error));
    }


    /* HEAD */
    public handleSubTypeHead(): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.head<SubType>(url, {params: params})
            .catch((error: Response) => this.handleError(error));
    }


    /* POST */
    public setIdPost(id: number, body: SubType): Observable<SubType[]> {
        const url = this.serviceBaseURL + '/type/' + id + '/' + typeRef + '';
        const params = new HttpParams();
        return this.httpClient.post<SubType[]>(url, body, {params: params})
            .catch((error: Response) => this.handleError(error));
    }

    public updatePersonPost(id: number, rootType: MyTypeScriptType): Observable<MyTypeScriptType> {
        const url = this.serviceBaseURL + '/person/' + id + '';
        const params = new HttpParams();
        return this.httpClient.post<MyTypeScriptType>(url, rootType, {params: params})
            .catch((error: Response) => this.handleError(error));
    }


    /* PUT */
    public handleSubTypePut(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.put<SubType>(url, param, {params: params})
            .catch((error: Response) => this.handleError(error));
    }


    /* PATCH */
    public handleSubTypePatch(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.patch<SubType>(url, param, {params: params})
            .catch((error: Response) => this.handleError(error));
    }


    /* DELETE */
    public handleSubTypeDelete(): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.delete<SubType>(url, {params: params})
          .catch((error: Response) => this.handleError(error));
    }


    /* OPTIONS */
    public handleSubTypeOptions(): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.options<SubType>(url, {params: params})
            .catch((error: Response) => this.handleError(error));
    }



    private handleError(error: Response) {
        // in a real world app, we may send the error to some remote logging infrastructure
        // instead of just logging it to the console
        console.error(error);
        return Observable.throw(error);
    }

}

