import { NgModule, ModuleWithProviders, Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { SecondTypeScriptEndpoint } from './secondtypescriptendpoint.generated';
import { TestTypeScriptEndpoint } from './testtypescriptendpoint.generated';
import { LombokTypeScriptEndpoint } from './lomboktypescriptendpoint.generated';

@Injectable()
export interface ServiceConfig {
    context?: string;
    debug?: boolean;
    onError()?: Observable<any>;
}

@NgModule({})
export class APIModule {
    static forRoot(serviceConfig: ServiceConfig = {context: ''}): ModuleWithProviders {
        return {
            ngModule: APIModule,
            providers: [
                {provide: ServiceConfig, useValue: serviceConfig},
                SecondTypeScriptEndpoint,
                TestTypeScriptEndpoint,
                LombokTypeScriptEndpoint
            ]
        };
    }
}

