import { SubType } from './subtype.model.generated';
import { SimpleEnum } from './simpleenum.model.generated';
import { MapValueType } from './mapvaluetype.model.generated';
import { MyTypeScriptType } from './mytypescripttype.model.generated';
import { MapKeyType } from './mapkeytype.model.generated';
import { ServiceConfig } from './api.module';

import { HttpClient, HttpParams, HttpRequest } from '@angular/common/http';
import { Injectable } from '@angular/core';

import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/observable/throw';
import 'rxjs/add/operator/map';

@Injectable()
export class SecondTypeScriptEndpoint {
    private get serviceBaseURL(): string {
        return this.serviceConfig.context + '/api';
    }
    private get onError(): Function {
        return this.serviceConfig.onError || this.handleError.bind(this);
    }
    constructor(private httpClient: HttpClient, private serviceConfig: ServiceConfig) { }
    /* GET */
    public getPersonsGet(body: any | null): Observable<MyTypeScriptType[]> {
        const url = this.serviceBaseURL + '/persons';
        const params = new HttpParams();
        return this.httpClient.get<MyTypeScriptType[]>(url, {params: params})
            .catch((error: Response) => this.onError(error));
    }

    public getPersonGet(body: any | null, id: number, typeRef: string): Observable<MyTypeScriptType> {
        const url = this.serviceBaseURL + '/person/' + id + '/' + typeRef + '';
        const params = new HttpParams();
        return this.httpClient.get<MyTypeScriptType>(url, {params: params})
            .catch((error: Response) => this.onError(error));
    }

    public mapsGet(body: any | null): Observable<{ [index: string]: MyTypeScriptType }> {
        const url = this.serviceBaseURL + '/maps';
        const params = new HttpParams();
        return this.httpClient.get<{ [index: string]: MyTypeScriptType }>(url, {params: params})
            .catch((error: Response) => this.onError(error));
    }


    /* HEAD */
    public handleSubTypeHead(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.head<SubType>(url, {params: params})
            .catch((error: Response) => this.onError(error));
    }


    /* POST */
    public setIdPost(body: SubType, id: number): Observable<SubType[]> {
        const url = this.serviceBaseURL + '/type/' + id + '';
        const params = new HttpParams();
        return this.httpClient.post<SubType[]>(url, body, {params: params})
            .catch((error: Response) => this.onError(error));
    }

    public updatePersonPost(rootType: MyTypeScriptType, id: number): Observable<MyTypeScriptType> {
        const url = this.serviceBaseURL + '/person/' + id + '';
        const params = new HttpParams();
        return this.httpClient.post<MyTypeScriptType>(url, rootType, {params: params})
            .catch((error: Response) => this.onError(error));
    }


    /* PUT */
    public handleSubTypePut(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.put<SubType>(url, param, {params: params})
            .catch((error: Response) => this.onError(error));
    }


    /* PATCH */
    public handleSubTypePatch(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.patch<SubType>(url, param, {params: params})
            .catch((error: Response) => this.onError(error));
    }


    /* DELETE */
    public handleSubTypeDelete(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.delete<SubType>(url, {params: params})
          .catch((error: Response) => this.onError(error));
    }


    /* OPTIONS */
    public handleSubTypeOptions(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = new HttpParams();
        return this.httpClient.options<SubType>(url, {params: params})
            .catch((error: Response) => this.onError(error));
    }



    private handleError(error: Response) {
        // in a real world app, we may send the error to some remote logging infrastructure
        // instead of just logging it to the console
        this.log('error', error);
        return Observable.throw(error);
    }

    private log(level: string, message: any) {
        if (this.serviceConfig.debug) {
            console[level](message);
        }
    }

}

