import { NgModule, ModuleWithProviders } from '@angular/core';
import { TestTypeScriptEndpoint } from './testtypescriptendpoint.generated';
import { LombokTypeScriptEndpoint } from './lomboktypescriptendpoint.generated';
import { SecondTypeScriptEndpoint } from './secondtypescriptendpoint.generated';
import { PersonEndpoint } from './personendpoint.generated';
import { ServiceConfig } from './serviceconfig';

@NgModule({})
export class APIModule {
    static forRoot(serviceConfig: ServiceConfig = {context: ''}): ModuleWithProviders {
        return {
            ngModule: APIModule,
            providers: [
                {provide: ServiceConfig, useValue: serviceConfig},
                TestTypeScriptEndpoint,
                LombokTypeScriptEndpoint,
                SecondTypeScriptEndpoint,
                PersonEndpoint
            ]
        };
    }
}
