import { HttpClient, HttpParams, HttpRequest, HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';

import { Observable } from 'rxjs/Observable';
import { ErrorObservable } from 'rxjs/observable/ErrorObservable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/observable/throw';
import 'rxjs/add/operator/map';

import { LombokRequest } from './lombokrequest.model.generated';
import { SubType } from './subtype.model.generated';
import { SimpleEnum } from './simpleenum.model.generated';
import { MapValueType } from './mapvaluetype.model.generated';
import { MyTypeScriptType } from './mytypescripttype.model.generated';
import { MapKeyType } from './mapkeytype.model.generated';
import { LombokResponse } from './lombokresponse.model.generated';
import { ServiceConfig } from './serviceconfig';

@Injectable()
export class LombokTypeScriptEndpoint {
    private get serviceBaseURL(): string {
        return this.serviceConfig.context + '/api';
    }
    private get onError(): (error: HttpErrorResponse) => ErrorObservable {
        return this.serviceConfig.onError || this.handleError.bind(this);
    }

    constructor(private httpClient: HttpClient, private serviceConfig: ServiceConfig) { }
    /* GET */

    /* HEAD */

    /* POST */
    public setIdPost(idPathVariable: number, typeRef: string, body?: LombokRequest, queryRequestParam?: string): Observable<LombokResponse<SubType[], any[], boolean, { [index: string]: string }, SubType>> {
        const url = this.serviceBaseURL + '/type/' + idPathVariable + '/' + typeRef + '';
        const params = this.createHttpParams({
            queryRequestParam: queryRequestParam
        });

        return this.httpClient.post<LombokResponse<SubType[], any[], boolean, { [index: string]: string }, SubType>>(url, body, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }

    public setFooPost(idPathVariable: number, typeRef: string, body?: LombokRequest, queryRequestParam?: string): Observable<LombokResponse<MyTypeScriptType[], any[], boolean, SubType, MyTypeScriptType>> {
        const url = this.serviceBaseURL + '/foo/' + idPathVariable + '/' + typeRef + '';
        const params = this.createHttpParams({
            queryRequestParam: queryRequestParam
        });

        return this.httpClient.post<LombokResponse<MyTypeScriptType[], any[], boolean, SubType, MyTypeScriptType>>(url, body, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }

    public setResponseEntityPost(idPathVariable: number, typeRef: string, body?: LombokRequest, queryRequestParam?: string): Observable<LombokResponse<MyTypeScriptType[], any[], boolean, SubType, MyTypeScriptType>> {
        const url = this.serviceBaseURL + '/foo/' + idPathVariable + '/' + typeRef + '';
        const params = this.createHttpParams({
            queryRequestParam: queryRequestParam
        });

        return this.httpClient.post<LombokResponse<MyTypeScriptType[], any[], boolean, SubType, MyTypeScriptType>>(url, body, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }

    public fileUploadPost(id: number, uploadfile: FormData): Observable<LombokResponse<MyTypeScriptType[], any[], boolean, SubType, MyTypeScriptType>> {
        const url = this.serviceBaseURL + '/upload/' + id + '';
        const params = this.createHttpParams({});

        return this.httpClient.post<LombokResponse<MyTypeScriptType[], any[], boolean, SubType, MyTypeScriptType>>(url, uploadfile, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* PUT */

    /* PATCH */

    /* DELETE */

    /* OPTIONS */


    private handleError(error: HttpErrorResponse): ErrorObservable {
        // in a real world app, we may send the error to some remote logging infrastructure
        // instead of just logging it to the console
        this.log('error', error);

        return Observable.throw(error);
    }

    private log(level: string, message: any): void {
        if (this.serviceConfig.debug) {
            console[level](message);
        }
    }

    private createHttpParams(values: { [index: string]: any }): HttpParams {
        let params: HttpParams = new HttpParams();

        Object.keys(values).forEach((key: string) => {
            const value: any = values[key];
            if (value != undefined) {
                params = params.set(key, String(value));
            }
        });

        return params;
    }
}
