import { HttpClient, HttpParams, HttpRequest, HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';

import { Observable } from 'rxjs/Observable';
import { ErrorObservable } from 'rxjs/observable/ErrorObservable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/observable/throw';
import 'rxjs/add/operator/map';

import { SubType } from './subtype.model.generated';
import { SimpleEnum } from './simpleenum.model.generated';
import { MapValueType } from './mapvaluetype.model.generated';
import { MyTypeScriptType } from './mytypescripttype.model.generated';
import { MapKeyType } from './mapkeytype.model.generated';
import { ServiceConfig } from './serviceconfig';

@Injectable()
export class TestTypeScriptEndpoint {
    private get serviceBaseURL(): string {
        return this.serviceConfig.context + '/api';
    }
    private get onError(): (error: HttpErrorResponse) => ErrorObservable {
        return this.serviceConfig.onError || this.handleError.bind(this);
    }

    constructor(private httpClient: HttpClient, private serviceConfig: ServiceConfig) { }
    /* GET */
    public getPersonsGet(): Observable<MyTypeScriptType[]> {
        const url = this.serviceBaseURL + '/persons';
        const params = this.createHttpParams({});

        return this.httpClient.get<MyTypeScriptType[]>(url, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }

    public getPersonGet(id: number, typeRef: string): Observable<MyTypeScriptType> {
        const url = this.serviceBaseURL + '/person/' + id + '/' + typeRef + '';
        const params = this.createHttpParams({});

        return this.httpClient.get<MyTypeScriptType>(url, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }

    public mapsGet(): Observable<{ [index: string]: MyTypeScriptType }> {
        const url = this.serviceBaseURL + '/maps';
        const params = this.createHttpParams({});

        return this.httpClient.get<{ [index: string]: MyTypeScriptType }>(url, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* HEAD */
    public handleSubTypeHead(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = this.createHttpParams({});

        return this.httpClient.head<SubType>(url, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* POST */
    public setIdPost(id: number, body: SubType): Observable<SubType[]> {
        const url = this.serviceBaseURL + '/type/' + id + '';
        const params = this.createHttpParams({});

        return this.httpClient.post<SubType[]>(url, body, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }

    public updatePersonPost(id: number, rootType: MyTypeScriptType): Observable<MyTypeScriptType> {
        const url = this.serviceBaseURL + '/person/' + id + '';
        const params = this.createHttpParams({});

        return this.httpClient.post<MyTypeScriptType>(url, rootType, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* PUT */
    public handleSubTypePut(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = this.createHttpParams({});

        return this.httpClient.put<SubType>(url, param, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* PATCH */
    public handleSubTypePatch(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = this.createHttpParams({});

        return this.httpClient.patch<SubType>(url, param, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* DELETE */
    public handleSubTypeDelete(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = this.createHttpParams({});

        return this.httpClient.delete<SubType>(url, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }


    /* OPTIONS */
    public handleSubTypeOptions(param: SubType): Observable<SubType> {
        const url = this.serviceBaseURL + '/subType';
        const params = this.createHttpParams({});

        return this.httpClient.options<SubType>(url, {params: params})
            .catch((error: HttpErrorResponse) => this.onError(error));
    }



    private handleError(error: HttpErrorResponse): ErrorObservable {
        // in a real world app, we may send the error to some remote logging infrastructure
        // instead of just logging it to the console
        this.log('error', error);

        return Observable.throw(error);
    }

    private log(level: string, message: any): void {
        if (this.serviceConfig.debug) {
            console[level](message);
        }
    }

    private createHttpParams(values: { [index: string]: any }): HttpParams {
        let params: HttpParams = new HttpParams();

        Object.keys(values).forEach((key: string) => {
            const value: any = values[key];
            if (value != undefined) {
                params = params.set(key, String(value));
            }
        });

        return params;
    }
}
