/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.examples.abstractbase;

import java.util.Optional;
import org.leandreck.endpoints.examples.abstractbase.Moveable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class BaseEndpoint<T>
implements Moveable {
    private T useLessField;

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public T create(@RequestBody T newEntity) {
        this.useLessField = newEntity;
        return newEntity;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public T update(@PathVariable String id, @RequestBody T updatedEntity) {
        return updatedEntity;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Optional<T> read(@PathVariable String id) {
        return Optional.of(this.useLessField);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public abstract void delete(@PathVariable String var1);
}

