/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Stack;
import org.leialearns.common.TypedIterable;

public class Display {
    private Display() {
        throw new UnsupportedOperationException("This class must not be instantiated: " + this.getClass().getSimpleName());
    }

    public static String show(String s) {
        StringBuilder builder = new StringBuilder();
        if (s != null) {
            for (char ch : s.toCharArray()) {
                Display.addCharacter(builder, ch);
            }
        }
        return builder.toString();
    }

    private static void addCharacter(StringBuilder builder, char ch) {
        switch (ch) {
            case ' ': {
                builder.append('_');
                break;
            }
            case '\n': {
                builder.append("\\n");
                break;
            }
            case '\t': {
                builder.append("\\t");
                break;
            }
            case '\r': {
                builder.append("\\r");
                break;
            }
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '_': 
            case '{': 
            case '}': {
                builder.append('\\');
                builder.append(ch);
                break;
            }
            default: {
                if (ch > ' ' && ch <= '~') {
                    builder.append(ch);
                    break;
                }
                if (ch <= '\u00ff') {
                    builder.append("\\x");
                    builder.append(String.format("%02X", ch));
                    break;
                }
                builder.append("\\u");
                builder.append(String.format("%04X", ch));
            }
        }
    }

    public static String displayParts(Object ... parts) {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Object part : parts) {
            if (first) {
                first = false;
            } else {
                builder.append('|');
            }
            if (part == null) {
                builder.append('?');
                continue;
            }
            builder.append(Display.display(part));
        }
        builder.append(']');
        return builder.toString();
    }

    public static Object asDisplayWithTypes(final Object object) {
        return new Object(){

            public String toString() {
                return Display.displayWithTypes(object);
            }
        };
    }

    public static String displayWithTypes(Object object) {
        StringBuilder builder = new StringBuilder();
        Display.displayRecursive(object, builder, new Stack<Object>(), true);
        return builder.toString();
    }

    public static Object asDisplay(final Object object) {
        return new Object(){

            public String toString() {
                return Display.display(object);
            }
        };
    }

    public static String display(Object object) {
        StringBuilder builder = new StringBuilder();
        Display.displayRecursive(object, builder, new Stack<Object>(), false);
        return builder.toString();
    }

    public static String display(Object first, Object second, Object ... remainder) {
        Object[] array = new Object[remainder.length + 2];
        array[0] = first;
        array[1] = second;
        System.arraycopy(remainder, 0, array, 2, remainder.length);
        return Display.display(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void displayRecursive(Object object, StringBuilder builder, Stack<Object> parents, boolean showTypes) {
        if (object == null) {
            builder.append("null");
        } else if (object instanceof String) {
            builder.append(Display.show(object.toString()));
        } else {
            boolean loop = false;
            for (Object e : parents) {
                if (object != e) continue;
                loop = true;
                break;
            }
            if (loop) {
                builder.append("...");
            } else {
                parents.push(object);
                try {
                    if (object.getClass().isArray()) {
                        Display.displayArray(object, builder, parents, showTypes);
                    } else if (object instanceof Iterable) {
                        Display.displayIterable((Iterable)object, builder, parents, showTypes);
                    } else if (object instanceof Class) {
                        Display.displayClass((Class)object, builder, parents, showTypes);
                    } else if (object instanceof Method) {
                        Display.displayMethod((Method)object, builder, parents, showTypes);
                    } else {
                        if (showTypes) {
                            Display.displayRecursiveWithTypes(object.getClass(), builder, parents);
                        }
                        builder.append(object.toString());
                    }
                }
                finally {
                    parents.pop();
                }
            }
        }
    }

    private static void displayRecursiveWithTypes(Object object, StringBuilder builder, Stack<Object> parents) {
        Display.displayRecursive(object, builder, parents, true);
    }

    private static void displayArray(Object object, StringBuilder builder, Stack<Object> parents, boolean showTypes) {
        if (showTypes && object.getClass().getComponentType() != Object.class) {
            builder.append('<');
            builder.append(object.getClass().getComponentType().getSimpleName());
            builder.append('>');
        }
        builder.append('[');
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            Display.displayRecursive(Array.get(object, i), builder, parents, showTypes);
        }
        builder.append(']');
    }

    private static void displayIterable(Iterable<?> iterable, StringBuilder builder, Stack<Object> parents, boolean showTypes) {
        if (showTypes) {
            builder.append('<');
            builder.append(iterable.getClass().getSimpleName());
            if (iterable instanceof TypedIterable) {
                builder.append('[');
                Display.displayRecursiveWithTypes(((TypedIterable)iterable).getType(), builder, new Stack<Object>());
                builder.append(']');
            }
            builder.append('>');
        }
        builder.append('{');
        boolean first = true;
        for (Object item : iterable) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            Display.displayRecursive(item, builder, parents, showTypes);
        }
        builder.append('}');
    }

    private static void displayClass(Class<?> type, StringBuilder builder, Stack<Object> parents, boolean showTypes) {
        builder.append('<');
        Class<?> superClass = type.getSuperclass();
        Class<?>[] interfaces = type.getInterfaces();
        if (superClass == Proxy.class) {
            builder.append("$->");
            type = null;
        } else if (superClass != null && type.getSimpleName().matches(".*[$].*CGLIB.*")) {
            builder.append("$->");
            type = superClass;
            superClass = type.getSuperclass();
        }
        if (type != null) {
            builder.append(type.getSimpleName());
        }
        if (showTypes && superClass != null && superClass != Object.class) {
            Display.displayRecursiveWithTypes(superClass, builder, parents);
        }
        if ((showTypes || type == null) && interfaces != null && interfaces.length > 0) {
            builder.append('|');
            for (Class<?> interfaceType : interfaces) {
                Display.displayRecursive(interfaceType, builder, parents, showTypes);
            }
        }
        builder.append('>');
    }

    private static void displayMethod(Method method, StringBuilder builder, Stack<Object> parents, boolean showTypes) {
        Display.displayClass(method.getDeclaringClass(), builder, parents, showTypes);
        builder.append('.');
        builder.append(method.getName());
        builder.append('(');
        boolean first = true;
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            Display.displayClass(parameterType, builder, parents, showTypes);
        }
        builder.append(')');
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            builder.append(" -> ");
            Display.displayClass(method.getReturnType(), builder, parents, showTypes);
        }
    }
}

