/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common;

import java.util.function.Function;
import java.util.function.Supplier;
import org.leialearns.common.Display;
import org.leialearns.common.Static;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Setting<T> {
    private final Logger logger = this.getLogger();
    private final String name;
    private final Supplier<T> defaultExpression;
    private final Object lock = new Object();
    private volatile T value = null;

    public Setting(String name, Supplier<T> defaultExpression) {
        this.name = name;
        this.defaultExpression = defaultExpression;
    }

    public Setting(String name, T defaultValue) {
        this(name, () -> defaultValue);
    }

    public Setting(String name) {
        this(name, null);
    }

    public void set(T value) {
        T thisValue;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Name: " + Display.display(this.name) + ": Value: " + Display.display(value), new Throwable("Stack trace"));
        }
        if ((thisValue = this.offerInternal(value)) != null) {
            throw new IllegalStateException("Value was already set to another value: " + this.name + " == [" + Display.display(thisValue) + "], not: [" + Display.display(value) + "]");
        }
    }

    public T get() {
        return (T)this.getInternal(x -> x, () -> {
            T defaultValue = this.defaultExpression.get();
            if (defaultValue == null) {
                throw new IllegalStateException("Value is not set: " + this.name);
            }
            this.value = defaultValue;
            return defaultValue;
        });
    }

    public boolean isFixated() {
        return this.getInternal(x -> true, () -> false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <Q> Q getInternal(Function<T, Q> successCase, Supplier<Q> failureCase) {
        Q result = null;
        T thisValue = this.value;
        if (thisValue == null) {
            Object object = this.lock;
            synchronized (object) {
                thisValue = this.value;
                if (thisValue == null) {
                    result = failureCase.get();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Use default value for setting: " + this.name + ": " + Display.display(result));
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Stack trace", new Throwable());
                    }
                }
            }
        }
        if (thisValue != null) {
            result = successCase.apply(thisValue);
        }
        return result;
    }

    public boolean offer(T value) {
        return this.offerInternal(value) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T offerInternal(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value should not be null: " + this.name);
        }
        T thisValue = this.value;
        if (thisValue == null) {
            Object object = this.lock;
            synchronized (object) {
                thisValue = this.value;
                if (thisValue == null) {
                    this.value = value;
                    this.logger.trace("Set [" + this.name + "] to: [" + value + "]");
                }
            }
        }
        this.logger.trace("Compare [" + thisValue + "] to: [" + value + "]");
        if (thisValue == null) {
            this.logger.trace("Null");
        } else if (thisValue == value) {
            thisValue = null;
        } else if (value.equals(thisValue)) {
            this.logger.warn("Weak identity: [" + thisValue + "] equals [" + value + "]");
            thisValue = null;
        } else {
            this.logger.debug("Mismatch: [" + thisValue + "] differs from [" + value + "]");
        }
        return thisValue;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(Static.getLoggingClass(this));
    }

    public String toString() {
        return Display.displayParts("Setting", this.value);
    }
}

