/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common;

import javax.validation.constraints.NotNull;
import org.leialearns.common.Display;
import org.leialearns.common.L;
import org.leialearns.common.Static;

public class Pair<L extends Comparable<? super L>, R extends Comparable<? super R>>
implements Comparable<Pair<L, R>> {
    private final L left;
    private final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean equals(Object other) {
        return other instanceof Pair && Static.equal(this.left, ((Pair)other).left) && Static.equal(this.right, ((Pair)other).right);
    }

    public int hashCode() {
        return (this.left == null ? 0 : this.left.hashCode()) + (this.right == null ? 0 : this.right.hashCode());
    }

    public String toString() {
        return Display.displayParts("Pair", L.literal(this.left.toString()), L.literal(this.right.toString()));
    }

    @Override
    public int compareTo(@NotNull Pair<L, R> pair) {
        int result = this.compare((Comparable)this.left, (Comparable)pair.left);
        return result == 0 ? this.compare((Comparable)this.right, (Comparable)pair.right) : result;
    }

    protected <T extends Comparable<? super T>> int compare(T thisObject, T otherObject) {
        int result = thisObject == null ? (otherObject == null ? 0 : -1) : (otherObject == null ? 1 : thisObject.compareTo(otherObject));
        return result;
    }
}

