/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.leialearns.common.TypedIterable;

public class Static {
    private Static() {
        throw new UnsupportedOperationException("This class must not be instantiated: " + this.getClass().getSimpleName());
    }

    public static <T> Iterable<T> notNull(Iterable<T> iterable) {
        return iterable == null ? Collections.EMPTY_LIST : iterable;
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    public static <T extends Comparable<T>> int compare(T left, T right) {
        int result = left == null ? (right == null ? 0 : -1) : (right == null ? 1 : left.compareTo(right));
        return result;
    }

    public static <T> T[] offer(T head, @NotNull T[] tail) {
        T[] result = Static.newArrayInstance(tail, tail.length + 1);
        result[0] = head;
        System.arraycopy(tail, 0, result, 1, tail.length);
        return result;
    }

    public static <T> T[] offerArray(T[] prepend, T[] tail) {
        if (prepend == null || prepend.length < 1) {
            return tail;
        }
        if (tail == null || tail.length < 1) {
            return prepend;
        }
        T[] result = Static.newArrayInstance(tail, prepend.length + tail.length);
        System.arraycopy(prepend, 0, result, 0, prepend.length);
        System.arraycopy(tail, 0, result, prepend.length, tail.length);
        return result;
    }

    public static <T> T[] newArrayInstance(T[] template, int length) {
        return Static.newArrayInstance(template.getClass().getComponentType(), length);
    }

    public static <T> T[] newArrayInstance(Class<T> baseClass, int length) {
        return (Object[])Array.newInstance(baseClass, length);
    }

    public static boolean equal(Object thisObject, Object thatObject) {
        return thisObject == null ? thatObject == null : thisObject.equals(thatObject);
    }

    public static Class<?> getLoggingClass(Object object) {
        Class<?> result = object.getClass();
        if (result.getSimpleName().matches(".*[$].*CGLIB.*")) {
            result = result.getSuperclass();
        }
        return result;
    }

    public static String join(String separator, String[] parts) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (first) {
                first = false;
            } else {
                builder.append(separator);
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static <T> List<T> toList(TypedIterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    public static long gcd(long a, long b) {
        BigInteger aa = BigInteger.valueOf(a);
        BigInteger bb = BigInteger.valueOf(b);
        return aa.gcd(bb).longValue();
    }
}

