/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.leialearns.common.HasWrappedIterable;

public class TypedIterable<T>
implements Iterable<T>,
HasWrappedIterable {
    private final Iterable<T> iterable;
    private final Class<T> type;

    public TypedIterable(Iterable<T> iterable, Class<T> type) {
        this.iterable = iterable;
        this.type = type;
    }

    public TypedIterable(Class<T> type, Iterable<?> iterable) {
        this(TypedIterable.cast(iterable, type), type);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Iterable<?> getWrappedIterable() {
        return this.iterable;
    }

    public T first() {
        Iterator<T> iterator = this.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    private static <T> Iterable<T> cast(Iterable<?> iterable, Class<T> type) {
        for (Object object : iterable) {
            type.cast(object);
        }
        return iterable;
    }
}

