/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.leialearns.common.Setting;
import org.leialearns.common.logging.LineFilter;

public class LineFilterInputStream
extends InputStream {
    private BufferedReader reader;
    private LineFilter lineFilter;
    private byte[] buffer = new byte[]{10};
    private int index = 0;
    private final Setting<Boolean> verbose = new Setting<Boolean>("Verbose", false);

    public LineFilterInputStream(Reader reader, LineFilter lineFilter) throws IOException {
        this(reader, lineFilter, null);
    }

    public LineFilterInputStream(Reader reader, LineFilter lineFilter, Boolean verbose) throws IOException {
        if (verbose != null) {
            this.verbose.set(verbose);
        }
        if (reader == null) {
            throw new IllegalArgumentException("The reader should not be null");
        }
        if (lineFilter == null) {
            throw new IllegalArgumentException("The lineFilter should not be null");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.lineFilter = lineFilter;
        this.nextLine();
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.buffer.length) {
            this.nextLine();
        }
        int result = this.index < this.buffer.length ? this.buffer[this.index++] : -1;
        return result;
    }

    protected void nextLine() throws IOException {
        if (this.buffer.length > 0) {
            String line = this.reader.readLine();
            if (line == null) {
                this.buffer = new byte[0];
            } else {
                line = this.lineFilter.filterLine(line);
                line = line + '\n';
                this.buffer = line.getBytes("utf-8");
            }
            this.index = 0;
            if (this.verbose.get().booleanValue()) {
                System.err.print("Line: ");
                System.err.print(line);
            }
        }
    }
}

