/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common.logging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.LogManager;
import org.leialearns.common.logging.LineFilterInputStream;

public class LogConfigurator {
    private final String logDir;

    public LogConfigurator(String logDir) throws IOException {
        this.logDir = logDir;
        File logDirFile = new File(logDir);
        if (!logDirFile.exists() && !logDirFile.mkdirs()) {
            System.err.println("Failed to create directory: " + logDir);
        }
    }

    public void configure(InputStream loggingProperties) throws IOException {
        System.err.println("Configuring logging using log directory: " + this.logDir);
        InputStreamReader logConfigReader = new InputStreamReader(loggingProperties);
        LineFilterInputStream logConfigStream = new LineFilterInputStream(logConfigReader, line -> line.replaceAll("LOG_DIR", this.logDir));
        LogManager logManager = LogManager.getLogManager();
        logManager.readConfiguration(logConfigStream);
    }
}

