/*
 * Decompiled with CFR 0.152.
 */
package org.leialearns.common.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.leialearns.common.Setting;
import org.leialearns.common.Static;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class SimpleFormatter
extends Formatter {
    private static final Logger logger = LoggerFactory.getLogger((String)"stack-trace");
    private static final Pattern ORGANISATION_RE = Pattern.compile("^([^.]*[.][^.]*)[.](.*)$");
    private static final ThreadLocal<DateFormat> DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    };
    private static final String[] DISMISS_RE_PARTS = new String[]{"com[.]sun[.]proxy[.]", "java[.]lang[.]reflect|sun[.]reflect[.]", "net[.]sf[.]cglib", "org[.]apache[.]maven[.]", "org[.]hibernate[.]", "org[.]junit[.]", "org[.]leialearns[.]bridge[.]BridgeFactory[.$]", "org[.]neo4j[.]", "org[.]springframework[.]", "sun[.]proxy[.]", "[^(]*CGLIB[$][$]"};
    private static final Pattern DISMISS_RE = Pattern.compile("^([\t ]*at )(" + Static.join("|", DISMISS_RE_PARTS) + ")(.*\n)", 8);
    private static final Pattern CAUSED_BY_RE = Pattern.compile("^Caused by", 8);
    private static final Pattern HEAD_RE = Pattern.compile("^((?:(?:[\t ]*at   |[^\t ])[^\n]*\n)*).*", 32);
    private static final Pattern DELETE_RE = Pattern.compile("(^[\t ]*at   .*\n)+", 8);
    private final Setting<Boolean> regexFormat = new SilentSetting<Boolean>("Regex format flag", false);

    public void setRegexFormat(boolean flag) {
        this.regexFormat.set(flag);
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder builder = new StringBuilder();
        long millis = logRecord.getMillis();
        String timestamp = DATE_FORMATTER.get().format(new Date(millis));
        String level = logRecord.getLevel().getName();
        String message = logRecord.getMessage();
        message = message.replace("\n", "\n        ");
        String organisation = "";
        String sourceClass = logRecord.getSourceClassName();
        if (this.regexFormat.get().booleanValue()) {
            Matcher matcher = ORGANISATION_RE.matcher(sourceClass);
            if (matcher.matches()) {
                organisation = matcher.group(1);
                sourceClass = matcher.group(2);
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(sourceClass, ".");
            ArrayList<String> organisationList = new ArrayList<String>();
            String[] sourceClassList = new LinkedList();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (organisationList.size() < 2) {
                    organisationList.add(token);
                    continue;
                }
                sourceClassList.addFirst(token);
            }
            if (!sourceClassList.isEmpty()) {
                organisation = this.implode(".", organisationList);
                ListIterator it = sourceClassList.listIterator();
                int first = 1;
                int length = 0;
                do {
                    String part = (String)it.next();
                    int partLength = part.length();
                    int wasFirst = first;
                    if (first != 0) {
                        first = 0;
                    } else {
                        ++partLength;
                    }
                    if (wasFirst != 0 || length + partLength < 40) {
                        length += partLength;
                        continue;
                    }
                    it.previous();
                    break;
                } while (it.hasNext());
                ArrayList<String> partList = new ArrayList<String>();
                while (it.hasPrevious()) {
                    String part = (String)it.previous();
                    partList.add(part);
                }
                sourceClass = this.implode(".", partList);
            }
        }
        String sourceMethod = logRecord.getSourceMethodName();
        boolean first = true;
        for (String part : new String[]{timestamp, this.fix(level, 8), organisation, sourceClass, sourceMethod, message}) {
            if (first) {
                first = false;
            } else {
                builder.append("|");
            }
            builder.append(part);
        }
        builder.append('\n');
        Throwable thrown = logRecord.getThrown();
        if (thrown != null && logger.isDebugEnabled()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            thrown.printStackTrace(printWriter);
            printWriter.close();
            String stackTrace = stringWriter.toString();
            stackTrace = DISMISS_RE.matcher(stackTrace).replaceAll("$1  $2$3");
            if (!logger.isTraceEnabled()) {
                try {
                    String block;
                    StringBuilder stackBuilder = new StringBuilder();
                    Matcher causedBy = CAUSED_BY_RE.matcher(stackTrace);
                    int pos = 0;
                    while (causedBy.find()) {
                        int nextPos = causedBy.start();
                        block = stackTrace.substring(pos, nextPos);
                        pos = nextPos;
                        stackBuilder.append(this.reduceStackBlock(block));
                    }
                    block = stackTrace.substring(pos);
                    stackBuilder.append(this.reduceStackBlock(block));
                    stackTrace = stackBuilder.toString();
                }
                catch (Throwable throwable) {
                    stackTrace = ">>> REDUCE FAILED: " + throwable + "\n" + stackTrace;
                }
            }
            builder.append(stackTrace);
        }
        return builder.toString();
    }

    protected String reduceStackBlock(String block) {
        String result;
        Matcher matcher = HEAD_RE.matcher(block);
        if (!matcher.matches()) {
            result = ">>> SPLIT FAILED\n" + block;
        } else {
            String head = matcher.group(1);
            String tail = block.substring(matcher.end(1));
            tail = DELETE_RE.matcher(tail).replaceAll("\t[...]\n");
            result = head + tail;
        }
        return result;
    }

    protected String fix(String field, int width) {
        StringBuilder result = new StringBuilder();
        int n = field.length();
        if (n > width) {
            result.append(field.substring(n - width));
        } else {
            result.append(field);
        }
        for (n = result.length(); n < width; ++n) {
            result.insert(0, ' ');
        }
        return result.toString();
    }

    protected String implode(String separator, List<String> parts) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (first) {
                first = false;
            } else {
                builder.append(separator);
            }
            builder.append(part);
        }
        return builder.toString();
    }

    protected class SilentSetting<T>
    extends Setting<T> {
        protected SilentSetting(String label, T defaultValue) {
            super(label, defaultValue);
        }

        @Override
        public Logger getLogger() {
            return NOPLogger.NOP_LOGGER;
        }
    }
}

