/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.Serializable;
import org.grouplens.grapht.annotation.DefaultProvider;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.inject.Shareable;
import org.lenskit.slopeone.SlopeOneModelProvider;

@DefaultProvider(value=SlopeOneModelProvider.class)
@Shareable
public class SlopeOneModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long2ObjectMap<ImmutableSparseVector> matrix;
    public static final Symbol CORATINGS_SYMBOL = Symbol.of((String)"coratings");

    public SlopeOneModel(Long2ObjectMap<ImmutableSparseVector> matrix) {
        this.matrix = matrix;
    }

    public double getDeviation(long item1, long item2) {
        if (item1 == item2) {
            return 0.0;
        }
        if (item1 < item2) {
            SparseVector row = (SparseVector)this.matrix.get(item1);
            if (row == null) {
                return Double.NaN;
            }
            return row.get(item2, Double.NaN);
        }
        SparseVector row = (SparseVector)this.matrix.get(item2);
        if (row == null) {
            return Double.NaN;
        }
        return -row.get(item1, Double.NaN);
    }

    public int getCoratings(long item1, long item2) {
        if (item1 == item2) {
            return 0;
        }
        if (item1 < item2) {
            SparseVector row = (SparseVector)this.matrix.get(item1);
            if (row == null) {
                return 0;
            }
            double coratings = row.getChannelVector(CORATINGS_SYMBOL).get(item2, 0.0);
            return (int)coratings;
        }
        SparseVector row = (SparseVector)this.matrix.get(item2);
        if (row == null) {
            return 0;
        }
        double coratings = row.getChannelVector(CORATINGS_SYMBOL).get(item1, 0.0);
        return (int)coratings;
    }
}

