/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.data.dao.ItemDAO;
import org.lenskit.inject.Transient;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.lenskit.slopeone.DeviationDamping;
import org.lenskit.slopeone.SlopeOneModel;
import org.lenskit.slopeone.SlopeOneModelDataAccumulator;

public class SlopeOneModelProvider
implements Provider<SlopeOneModel> {
    private final SlopeOneModelDataAccumulator accumulator;
    private final ItemItemBuildContext buildContext;

    @Inject
    public SlopeOneModelProvider(@Transient @Nonnull ItemDAO dao, @Transient ItemItemBuildContext context, @DeviationDamping double damping) {
        this.buildContext = context;
        this.accumulator = new SlopeOneModelDataAccumulator(damping, dao);
    }

    public SlopeOneModel get() {
        LongSortedSet items = this.buildContext.getItems();
        LongIterator outer = items.iterator();
        while (outer.hasNext()) {
            long item1 = outer.nextLong();
            SparseVector vec1 = this.buildContext.itemVector(item1);
            LongIterator inner = items.iterator();
            while (inner.hasNext()) {
                long item2 = inner.nextLong();
                if (item1 == item2) continue;
                SparseVector vec2 = this.buildContext.itemVector(item2);
                this.accumulator.putItemPair(item1, vec1, item2, vec2);
            }
        }
        return new SlopeOneModel(this.accumulator.buildMatrix());
    }
}

