/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.lenskit.api.ResultMap;
import org.lenskit.basic.AbstractItemScorer;
import org.lenskit.data.ratings.PreferenceDomain;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.results.BasicResult;
import org.lenskit.results.Results;
import org.lenskit.slopeone.SlopeOneModel;

public class SlopeOneItemScorer
extends AbstractItemScorer {
    protected final RatingVectorPDAO dao;
    protected SlopeOneModel model;
    protected final PreferenceDomain domain;

    @Inject
    public SlopeOneItemScorer(RatingVectorPDAO dao, SlopeOneModel model, @Nullable PreferenceDomain dom) {
        this.dao = dao;
        this.model = model;
        this.domain = dom;
    }

    @Nonnull
    public ResultMap scoreWithDetails(long user, @Nonnull Collection<Long> items) {
        Long2DoubleMap ratings = this.dao.userRatingVector(user);
        ImmutableSparseVector userVector = ImmutableSparseVector.create((Map)ratings);
        ArrayList<BasicResult> results = new ArrayList<BasicResult>();
        LongIterator iter = LongIterators.asLongIterator(items.iterator());
        while (iter.hasNext()) {
            long predicteeItem = iter.nextLong();
            if (userVector.containsKey(predicteeItem)) continue;
            double total = 0.0;
            int nitems = 0;
            for (VectorEntry e : userVector) {
                long currentItem = e.getKey();
                int nusers = this.model.getCoratings(predicteeItem, currentItem);
                if (nusers == 0) continue;
                double currentDev = this.model.getDeviation(predicteeItem, currentItem);
                total += currentDev + e.getValue();
                ++nitems;
            }
            if (nitems == 0) continue;
            double predValue = total / (double)nitems;
            if (this.domain != null) {
                predValue = this.domain.clampValue(predValue);
            }
            results.add(Results.create((long)predicteeItem, (double)predValue));
        }
        return Results.newResultMap(results);
    }

    public SlopeOneModel getModel() {
        return this.model;
    }
}

