/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.lenskit.data.dao.ItemDAO;
import org.lenskit.slopeone.SlopeOneModel;

public class SlopeOneModelDataAccumulator {
    private Long2ObjectMap<MutableSparseVector> workMatrix;
    private double damping;

    public SlopeOneModelDataAccumulator(double damping, ItemDAO dao) {
        this.damping = damping;
        LongSet items = dao.getItemIds();
        this.workMatrix = new Long2ObjectOpenHashMap(items.size());
        LongIterator iter = items.iterator();
        while (iter.hasNext()) {
            long item = iter.nextLong();
            this.workMatrix.put(item, (Object)MutableSparseVector.create((Collection)items));
            ((MutableSparseVector)this.workMatrix.get(item)).addChannelVector(SlopeOneModel.CORATINGS_SYMBOL);
        }
    }

    public void putItemPair(long id1, SparseVector itemVec1, long id2, SparseVector itemVec2) {
        if (this.workMatrix == null) {
            throw new IllegalStateException("Model is already built");
        }
        if (id1 < id2) {
            int coratings = 0;
            double deviation = 0.0;
            for (Pair pair : SparseVector.fastIntersect((SparseVector)itemVec1, (SparseVector)itemVec2)) {
                ++coratings;
                deviation += ((VectorEntry)pair.getLeft()).getValue() - ((VectorEntry)pair.getRight()).getValue();
            }
            deviation = coratings == 0 ? Double.NaN : deviation;
            ((MutableSparseVector)this.workMatrix.get(id1)).set(id2, deviation);
            ((MutableSparseVector)this.workMatrix.get(id1)).getChannelVector(SlopeOneModel.CORATINGS_SYMBOL).set(id2, (double)coratings);
        }
    }

    public Long2ObjectMap<ImmutableSparseVector> buildMatrix() {
        if (this.workMatrix == null) {
            throw new IllegalStateException("Model is already built");
        }
        Long2ObjectOpenHashMap matrix = new Long2ObjectOpenHashMap(this.workMatrix.size());
        for (MutableSparseVector vec : this.workMatrix.values()) {
            for (VectorEntry e : vec) {
                double deviation = e.getValue();
                int coratings = (int)vec.getChannelVector(SlopeOneModel.CORATINGS_SYMBOL).get(e);
                vec.set(e, deviation / ((double)coratings + this.damping));
            }
        }
        for (Map.Entry e : this.workMatrix.entrySet()) {
            matrix.put(e.getKey(), (Object)((MutableSparseVector)e.getValue()).freeze());
        }
        this.workMatrix = null;
        return matrix;
    }
}

