/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import java.io.Serializable;
import org.grouplens.grapht.annotation.DefaultProvider;
import org.lenskit.inject.Shareable;
import org.lenskit.slopeone.SlopeOneModelProvider;
import org.lenskit.util.keys.KeyedObject;
import org.lenskit.util.keys.KeyedObjectMap;
import org.lenskit.util.keys.SortedKeyIndex;

@DefaultProvider(value=SlopeOneModelProvider.class)
@Shareable
public class SlopeOneModel
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final KeyedObjectMap<ModelRow> matrix;

    public SlopeOneModel(KeyedObjectMap<ModelRow> matrix) {
        this.matrix = matrix;
    }

    public double getDeviation(long item1, long item2) {
        if (item1 == item2) {
            return 0.0;
        }
        if (item1 < item2) {
            ModelRow row = (ModelRow)this.matrix.get(item1);
            if (row == null) {
                return Double.NaN;
            }
            return row.getDeviation(item2);
        }
        ModelRow row = (ModelRow)this.matrix.get(item2);
        if (row == null) {
            return Double.NaN;
        }
        return -row.getDeviation(item1);
    }

    public int getCoratings(long item1, long item2) {
        if (item1 == item2) {
            return 0;
        }
        if (item1 < item2) {
            ModelRow row = (ModelRow)this.matrix.get(item1);
            if (row == null) {
                return 0;
            }
            return row.getCoratings(item2);
        }
        ModelRow row = (ModelRow)this.matrix.get(item2);
        if (row == null) {
            return 0;
        }
        return row.getCoratings(item1);
    }

    static class ModelRow
    implements Serializable,
    KeyedObject {
        private static final long serialVersionUID = 1L;
        private final long item;
        private final SortedKeyIndex items;
        private final double[] deviations;
        private final int[] coratings;

        ModelRow(long i, SortedKeyIndex is, double[] ds, int[] crs) {
            assert (ds.length == is.size());
            assert (crs.length == is.size());
            this.item = i;
            this.items = is;
            this.deviations = ds;
            this.coratings = crs;
        }

        public long getKey() {
            return this.item;
        }

        double getDeviation(long item) {
            int idx = this.items.tryGetIndex(item);
            if (idx >= 0) {
                return this.deviations[idx];
            }
            return Double.NaN;
        }

        int getCoratings(long item) {
            int idx = this.items.tryGetIndex(item);
            if (idx >= 0) {
                return this.coratings[idx];
            }
            return 0;
        }
    }
}

