/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleSortedMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.lenskit.slopeone.SlopeOneModel;
import org.lenskit.util.keys.KeyedObjectMap;
import org.lenskit.util.keys.KeyedObjectMapBuilder;
import org.lenskit.util.keys.SortedKeyIndex;

public class SlopeOneModelDataAccumulator {
    private Long2ObjectMap<Pair<Long2DoubleMap, Long2IntMap>> workMatrix;
    private double damping;

    public SlopeOneModelDataAccumulator(double damping, LongSet items) {
        this.damping = damping;
        this.workMatrix = new Long2ObjectOpenHashMap(items.size());
        LongIterator iter = items.iterator();
        while (iter.hasNext()) {
            long item = iter.nextLong();
            this.workMatrix.put(item, (Object)Pair.of((Object)new Long2DoubleOpenHashMap(), (Object)new Long2IntOpenHashMap()));
        }
    }

    public void putItemPair(long id1, Long2DoubleSortedMap itemVec1, long id2, Long2DoubleSortedMap itemVec2) {
        if (this.workMatrix == null) {
            throw new IllegalStateException("Model is already built");
        }
        if (id1 < id2) {
            int coratings = 0;
            double deviation = 0.0;
            LongBidirectionalIterator iter = itemVec1.keySet().iterator();
            while (iter.hasNext()) {
                long u = iter.nextLong();
                if (!itemVec2.containsKey(u)) continue;
                ++coratings;
                deviation += itemVec1.get(u) - itemVec2.get(u);
            }
            deviation = coratings == 0 ? Double.NaN : deviation;
            Pair row = (Pair)this.workMatrix.get(id1);
            ((Long2DoubleMap)row.getLeft()).put(id2, deviation);
            ((Long2IntMap)row.getRight()).put(id2, coratings);
        }
    }

    public KeyedObjectMap<SlopeOneModel.ModelRow> buildMatrix() {
        if (this.workMatrix == null) {
            throw new IllegalStateException("Model is already built");
        }
        KeyedObjectMapBuilder builder = KeyedObjectMap.newBuilder();
        for (Map.Entry e : this.workMatrix.entrySet()) {
            Long2DoubleMap vec = (Long2DoubleMap)((Pair)e.getValue()).getLeft();
            Long2IntMap cor = (Long2IntMap)((Pair)e.getValue()).getRight();
            SortedKeyIndex idx = SortedKeyIndex.fromCollection((Collection)vec.keySet());
            int n = idx.size();
            double[] deviations = new double[n];
            int[] counts = new int[n];
            for (int i = 0; i < n; ++i) {
                long item = idx.getKey(i);
                double deviation = vec.get(item);
                int coratings = cor.get(item);
                deviations[i] = deviation / ((double)coratings + this.damping);
                counts[i] = coratings;
            }
            builder.add((Object)new SlopeOneModel.ModelRow((Long)e.getKey(), idx, deviations, counts));
        }
        this.workMatrix = null;
        return builder.build();
    }
}

