/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.slopeone;

import it.unimi.dsi.fastutil.longs.Long2DoubleSortedMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import javax.inject.Inject;
import javax.inject.Provider;
import org.lenskit.inject.Transient;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.lenskit.slopeone.DeviationDamping;
import org.lenskit.slopeone.SlopeOneModel;
import org.lenskit.slopeone.SlopeOneModelDataAccumulator;

public class SlopeOneModelProvider
implements Provider<SlopeOneModel> {
    private final SlopeOneModelDataAccumulator accumulator;
    private final ItemItemBuildContext buildContext;

    @Inject
    public SlopeOneModelProvider(@Transient ItemItemBuildContext context, @DeviationDamping double damping) {
        this.buildContext = context;
        this.accumulator = new SlopeOneModelDataAccumulator(damping, (LongSet)context.getItems());
    }

    public SlopeOneModel get() {
        LongSortedSet items = this.buildContext.getItems();
        LongIterator outer = items.iterator();
        while (outer.hasNext()) {
            long item1 = outer.nextLong();
            Long2DoubleSortedMap vec1 = this.buildContext.itemVector(item1);
            LongIterator inner = items.iterator();
            while (inner.hasNext()) {
                long item2 = inner.nextLong();
                if (item1 == item2) continue;
                Long2DoubleSortedMap vec2 = this.buildContext.itemVector(item2);
                this.accumulator.putItemPair(item1, vec1, item2, vec2);
            }
        }
        return new SlopeOneModel(this.accumulator.buildMatrix());
    }
}

