/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.documents.store;

import com.io7m.jfunctional.FunctionType;
import com.io7m.jfunctional.Option;
import com.io7m.jfunctional.OptionType;
import com.io7m.jfunctional.Unit;
import com.io7m.jnull.NullCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.nypl.simplified.clock.ClockType;
import org.nypl.simplified.documents.eula.EULA;
import org.nypl.simplified.documents.eula.EULAType;
import org.nypl.simplified.documents.store.DocumentStoreBuilderType;
import org.nypl.simplified.documents.store.DocumentStoreType;
import org.nypl.simplified.documents.synced.SyncedDocument;
import org.nypl.simplified.documents.synced.SyncedDocumentType;
import org.nypl.simplified.http.core.HTTPType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentStore
implements DocumentStoreType {
    private static final Logger LOG = (Logger)NullCheck.notNull((Object)LoggerFactory.getLogger(DocumentStore.class));
    private final OptionType<SyncedDocumentType> privacy;
    private final OptionType<SyncedDocumentType> about;
    private final OptionType<SyncedDocumentType> acknowledgement;
    private final OptionType<SyncedDocumentType> licenses;
    private final OptionType<EULAType> eula;

    private DocumentStore(OptionType<SyncedDocumentType> in_acknowledgement, OptionType<SyncedDocumentType> in_privacy, OptionType<SyncedDocumentType> in_about, OptionType<SyncedDocumentType> in_licenses, OptionType<EULAType> in_eula) {
        this.acknowledgement = (OptionType)NullCheck.notNull(in_acknowledgement);
        this.about = (OptionType)NullCheck.notNull(in_about);
        this.privacy = (OptionType)NullCheck.notNull(in_privacy);
        this.eula = (OptionType)NullCheck.notNull(in_eula);
        this.licenses = (OptionType)NullCheck.notNull(in_licenses);
    }

    public static DocumentStoreBuilderType newBuilder(ClockType in_clock, HTTPType in_http, ExecutorService in_exec, File in_base) {
        return new Builder(in_clock, in_http, in_exec, in_base);
    }

    @Override
    public OptionType<SyncedDocumentType> getPrivacyPolicy() {
        return this.privacy;
    }

    @Override
    public OptionType<SyncedDocumentType> getAbout() {
        return this.about;
    }

    @Override
    public OptionType<SyncedDocumentType> getAcknowledgements() {
        return this.acknowledgement;
    }

    @Override
    public OptionType<EULAType> getEULA() {
        return this.eula;
    }

    @Override
    public OptionType<SyncedDocumentType> getLicenses() {
        return this.licenses;
    }

    private static class Builder
    implements DocumentStoreBuilderType {
        private final File base;
        private final ClockType clock;
        private final HTTPType http;
        private final ExecutorService exec;
        private OptionType<SyncedDocumentType> privacy;
        private OptionType<SyncedDocumentType> acknowledgments;
        private OptionType<SyncedDocumentType> about;
        private OptionType<SyncedDocumentType> licenses;
        private OptionType<EULAType> eula;

        Builder(ClockType in_clock, HTTPType in_http, ExecutorService in_exec, File in_base) {
            this.clock = (ClockType)NullCheck.notNull((Object)in_clock);
            this.http = (HTTPType)NullCheck.notNull((Object)in_http);
            this.exec = (ExecutorService)NullCheck.notNull((Object)in_exec);
            this.base = (File)NullCheck.notNull((Object)in_base);
            this.privacy = Option.none();
            this.about = Option.none();
            this.acknowledgments = Option.none();
            this.eula = Option.none();
            this.licenses = Option.none();
        }

        @Override
        public void enableEULA(FunctionType<Unit, InputStream> f) throws IOException {
            this.eula = Option.some((Object)EULA.newEULA(this.clock, this.http, this.exec, this.base, f));
        }

        @Override
        public void enablePrivacyPolicy(FunctionType<Unit, InputStream> f) throws IOException {
            this.privacy = Option.some((Object)SyncedDocument.newDocument(this.clock, this.http, this.exec, this.base, "privacy.html", f));
        }

        @Override
        public void enableAcknowledgements(FunctionType<Unit, InputStream> f) throws IOException {
            this.acknowledgments = Option.some((Object)SyncedDocument.newDocument(this.clock, this.http, this.exec, this.base, "acknowledgments.html", f));
        }

        @Override
        public void enableLicenses(FunctionType<Unit, InputStream> f) throws IOException {
            this.licenses = Option.some((Object)SyncedDocument.newDocument(this.clock, this.http, this.exec, this.base, "software-licenses.html", f));
        }

        @Override
        public void enableAbout(FunctionType<Unit, InputStream> f) throws IOException {
            this.about = Option.some((Object)SyncedDocument.newDocument(this.clock, this.http, this.exec, this.base, "about.html", f));
        }

        @Override
        public DocumentStoreType build() {
            return new DocumentStore(this.acknowledgments, this.privacy, this.about, this.licenses, this.eula);
        }
    }
}

