/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.documents.eula;

import com.io7m.jfunctional.FunctionType;
import com.io7m.jfunctional.Unit;
import com.io7m.jnull.NullCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nypl.simplified.clock.ClockType;
import org.nypl.simplified.documents.eula.EULAType;
import org.nypl.simplified.documents.synced.SyncedDocument;
import org.nypl.simplified.documents.synced.SyncedDocumentType;
import org.nypl.simplified.http.core.HTTPType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EULA
implements EULAType {
    private static final Logger LOG = (Logger)NullCheck.notNull((Object)LoggerFactory.getLogger(EULA.class));
    private final SyncedDocumentType actual;
    private final ExecutorService exec;
    private final File file_agreed;
    private final AtomicBoolean agreed;

    private EULA(ExecutorService in_exec, SyncedDocumentType in_actual, File in_agreed) {
        this.actual = (SyncedDocumentType)NullCheck.notNull((Object)in_actual);
        this.exec = in_exec;
        this.file_agreed = in_agreed;
        this.agreed = new AtomicBoolean(in_agreed.exists());
    }

    public static EULAType newEULA(ClockType clock, HTTPType http, ExecutorService exec, File base, FunctionType<Unit, InputStream> initial) throws IOException {
        SyncedDocumentType sd = SyncedDocument.newDocument(clock, http, exec, base, "eula.html", initial);
        File agree = new File(base, "eula_agreed.dat");
        return new EULA(exec, sd, agree);
    }

    @Override
    public URL documentGetReadableURL() {
        return this.actual.documentGetReadableURL();
    }

    @Override
    public void documentSetLatestURL(URL u) {
        this.actual.documentSetLatestURL(u);
    }

    @Override
    public boolean eulaHasAgreed() {
        return this.agreed.get();
    }

    @Override
    public void eulaSetHasAgreed(final boolean t) {
        this.agreed.set(t);
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    EULA.this.setFile(t);
                }
                catch (IOException e) {
                    LOG.error("could not save agreement flag file: ", (Throwable)e);
                }
            }
        });
    }

    private void setFile(boolean t) throws IOException {
        if (t) {
            this.file_agreed.createNewFile();
        } else {
            this.file_agreed.delete();
        }
    }
}

