/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.documents.synced;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.io7m.jfunctional.Option;
import com.io7m.jfunctional.OptionType;
import com.io7m.jfunctional.Pair;
import com.io7m.jfunctional.Unit;
import com.io7m.jnull.NonNull;
import com.io7m.jnull.NullCheck;
import com.io7m.junreachable.UnreachableCodeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.nypl.simplified.clock.ClockType;
import org.nypl.simplified.documents.synced.SyncedDocumentType;
import org.nypl.simplified.files.FileUtilities;
import org.nypl.simplified.http.core.HTTPResultError;
import org.nypl.simplified.http.core.HTTPResultException;
import org.nypl.simplified.http.core.HTTPResultMatcherType;
import org.nypl.simplified.http.core.HTTPResultOKType;
import org.nypl.simplified.http.core.HTTPType;
import org.nypl.simplified.json.core.JSONParserUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncedDocumentAbstract
implements SyncedDocumentType {
    private static final Logger LOG = (Logger)NullCheck.notNull((Object)LoggerFactory.getLogger(SyncedDocumentAbstract.class));
    private final File current;
    private final File meta;
    private final File current_tmp;
    private final AtomicLong fetch_last_success;
    private final ClockType clock;
    private final HTTPType http;
    private final ExecutorService exec;
    private final AtomicBoolean fetch_in_progress;
    private final File meta_tmp;
    private URL current_url;

    protected SyncedDocumentAbstract(ClockType in_clock, HTTPType in_http, ExecutorService in_exec, File in_current, File in_current_tmp, File in_meta, File in_meta_tmp, long in_fetch_last_success) {
        try {
            this.clock = (ClockType)NullCheck.notNull((Object)in_clock);
            this.http = (HTTPType)NullCheck.notNull((Object)in_http);
            this.exec = (ExecutorService)NullCheck.notNull((Object)in_exec);
            this.current = (File)NullCheck.notNull((Object)in_current);
            this.current_tmp = (File)NullCheck.notNull((Object)in_current_tmp);
            this.meta = (File)NullCheck.notNull((Object)in_meta);
            this.meta_tmp = (File)NullCheck.notNull((Object)in_meta_tmp);
            this.current_url = this.current.toURI().toURL();
            this.fetch_last_success = new AtomicLong(in_fetch_last_success);
            this.fetch_in_progress = new AtomicBoolean(false);
        }
        catch (MalformedURLException e) {
            throw new UnreachableCodeException((Throwable)e);
        }
    }

    protected static Pair<URI, Long> readMeta(File meta) throws IOException {
        NullCheck.notNull((Object)meta);
        ObjectMapper jom = new ObjectMapper();
        ObjectNode o = JSONParserUtilities.checkObject(null, (JsonNode)jom.readTree(meta));
        URI uri = JSONParserUtilities.getURI((ObjectNode)o, (String)"url");
        Long latest = JSONParserUtilities.getBigInteger((ObjectNode)o, (String)"last-fetch").longValue();
        return Pair.pair((Object)uri, (Object)latest);
    }

    protected abstract void documentOnReceipt(int var1, InputStream var2, String var3, File var4) throws IOException;

    @Override
    public synchronized URL documentGetReadableURL() {
        try {
            return this.current.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UnreachableCodeException((Throwable)e);
        }
    }

    @Override
    public synchronized void documentSetLatestURL(URL u) {
        NullCheck.notNull((Object)u);
        try {
            URI c_text = this.current_url.toURI();
            URI u_text = u.toURI();
            if (!c_text.equals(u_text)) {
                this.current_url = u;
                LOG.debug("new URL {}, fetch_in_progress {}", (Object)u, (Object)this.fetch_in_progress.get());
                this.runCheck(u);
            } else if (this.fetch_in_progress.compareAndSet(false, true)) {
                long diff = this.clock.clockNow().getMillis() - this.fetch_last_success.get();
                if (diff >= 86400L) {
                    LOG.debug("time difference {} >= 86400, fetch_in_progress {}", (Object)diff, (Object)this.fetch_in_progress.get());
                    this.runCheck(u);
                } else {
                    this.fetch_in_progress.set(false);
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.error("invalid URI {}, ignoring: ", (Throwable)e);
        }
    }

    private void runCheck(final URL u) {
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncedDocumentAbstract.this.fetch(u);
                }
                catch (Throwable e) {
                    LOG.error("fetch: {} failed: ", (Object)u, (Object)e);
                }
                finally {
                    SyncedDocumentAbstract.this.fetch_in_progress.set(false);
                }
            }
        });
    }

    private void fetch(final URL u) throws URISyntaxException, IOException {
        LOG.debug("fetch_in_progress {}", (Object)u);
        OptionType no_auth = Option.none();
        this.http.get(no_auth, u.toURI(), 0L).matchResult((HTTPResultMatcherType)new HTTPResultMatcherType<InputStream, Unit, IOException>(){

            public Unit onHTTPError(HTTPResultError<InputStream> e) throws IOException {
                SyncedDocumentAbstract.this.onHTTPError((HTTPResultError<InputStream>)e, u);
                return Unit.unit();
            }

            public Unit onHTTPException(HTTPResultException<InputStream> e) throws IOException {
                LOG.error("could not connect to server: ", (Throwable)e.getError());
                return Unit.unit();
            }

            public Unit onHTTPOK(HTTPResultOKType<InputStream> e) throws IOException {
                SyncedDocumentAbstract.this.onHTTPOK((HTTPResultOKType<InputStream>)e, u);
                return Unit.unit();
            }
        });
    }

    private void onHTTPError(HTTPResultError<InputStream> e, URL u) throws IOException {
        String type = this.getContentType(e.getResponseHeaders());
        this.documentOnReceipt(e.getStatus(), e.getData(), type, this.current_tmp);
        this.saveResults(u);
    }

    @NonNull
    private String getContentType(Map<String, List<String>> headers) {
        List<String> types = headers.get("Content-Type");
        String type = types.size() > 0 ? (String)NullCheck.notNull((Object)types.get(0)) : "application/octet-stream";
        return type;
    }

    private void onHTTPOK(HTTPResultOKType<InputStream> e, URL u) throws IOException {
        String type = this.getContentType(e.getResponseHeaders());
        this.documentOnReceipt(e.getStatus(), (InputStream)e.getValue(), type, this.current_tmp);
        this.saveResults(u);
    }

    private void saveResults(URL u) throws IOException {
        FileUtilities.fileRename((File)this.current_tmp, (File)this.current);
        long now = this.clock.clockNow().getMillis();
        this.writeMeta(u, now);
        this.fetch_last_success.set(now);
    }

    private void writeMeta(URL u, long now) throws IOException {
        ObjectMapper jom = new ObjectMapper();
        ObjectNode o = jom.createObjectNode();
        o.put("url", u.toString());
        o.put("last-fetch", now);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectWriter jw = jom.writerWithDefaultPrettyPrinter();
        jw.writeValue((OutputStream)bao, (Object)o);
        FileUtilities.fileWriteBytesAtomically((File)this.meta, (File)this.meta_tmp, (byte[])bao.toByteArray());
    }
}

