/*
 * Decompiled with CFR 0.152.
 */
package org.nypl.simplified.documents.synced;

import com.io7m.jfunctional.FunctionType;
import com.io7m.jfunctional.Pair;
import com.io7m.jfunctional.Unit;
import com.io7m.jnull.NullCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import org.nypl.simplified.clock.ClockType;
import org.nypl.simplified.documents.synced.SyncedDocumentAbstract;
import org.nypl.simplified.documents.synced.SyncedDocumentType;
import org.nypl.simplified.files.FileUtilities;
import org.nypl.simplified.http.core.HTTPType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncedDocument
extends SyncedDocumentAbstract {
    private static final Logger LOG = (Logger)NullCheck.notNull((Object)LoggerFactory.getLogger(SyncedDocument.class));

    private SyncedDocument(ClockType in_clock, HTTPType in_http, ExecutorService in_exec, File in_current, File in_current_tmp, File in_meta, File in_meta_tmp, long in_fetch_last_success) {
        super(in_clock, in_http, in_exec, in_current, in_current_tmp, in_meta, in_meta_tmp, in_fetch_last_success);
    }

    public static SyncedDocumentType newDocument(ClockType in_clock, HTTPType in_http, ExecutorService in_exec, File directory, String name, FunctionType<Unit, InputStream> initial) throws IOException {
        NullCheck.notNull((Object)in_clock);
        NullCheck.notNull((Object)in_http);
        NullCheck.notNull((Object)in_exec);
        NullCheck.notNull((Object)directory);
        NullCheck.notNull((Object)name);
        NullCheck.notNull(initial);
        File current = new File(directory, name);
        File current_tmp = new File(directory, name + ".tmp");
        File meta = new File(directory, name + ".meta");
        File meta_tmp = new File(directory, name + ".meta.tmp");
        LOG.debug("synced document [{}]: current:     {}", (Object)name, (Object)current);
        LOG.debug("synced document [{}]: current_tmp: {}", (Object)name, (Object)current_tmp);
        LOG.debug("synced document [{}]: meta:        {}", (Object)name, (Object)meta);
        LOG.debug("synced document [{}]: meta_tmp:    {}", (Object)name, (Object)meta_tmp);
        if (!current.isFile() || current.length() == 0L) {
            LOG.debug("synced document [{}]: initializing file", (Object)name);
            FileUtilities.fileWriteStreamAtomically((File)current, (File)current_tmp, (InputStream)((InputStream)initial.call((Object)Unit.unit())));
        }
        long fetched_last = 0L;
        if (meta.isFile()) {
            try {
                Pair<URI, Long> meta_data = SyncedDocumentAbstract.readMeta(meta);
                fetched_last = (Long)meta_data.getRight();
            }
            catch (IOException e) {
                LOG.error("could not read metadata: ", (Throwable)e);
            }
        }
        return new SyncedDocument(in_clock, in_http, in_exec, current, current_tmp, meta, meta_tmp, fetched_last);
    }

    @Override
    protected void documentOnReceipt(int status, InputStream data, String type, File output) throws IOException {
        if (status < 200 || status >= 300) {
            throw new IOException(String.format("Server returned status %d", status));
        }
        FileUtilities.fileWriteStream((File)output, (InputStream)data);
    }
}

