/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.lifstools.jgoslin.domain.AcylAlkylGroup;
import org.lifstools.jgoslin.domain.CarbonChain;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Cycle;
import org.lifstools.jgoslin.domain.Dictionary;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.GenericList;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidCompleteStructure;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidFullStructure;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidMolecularSpecies;
import org.lifstools.jgoslin.domain.LipidSnPosition;
import org.lifstools.jgoslin.domain.LipidSpecies;
import org.lifstools.jgoslin.domain.LipidStructureDefined;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class FattyAcidParserEventHandler
extends BaseParserEventHandler<LipidAdduct> {
    private final KnownFunctionalGroups knownFunctionalGroups;
    private LipidLevel level;
    private String headgroup;
    private ArrayDeque<FattyAcid> fattyAcylStack;
    private Dictionary tmp;
    private static final Map<String, Integer> LAST_NUMBERS = Map.ofEntries(Map.entry("un", 1), Map.entry("hen", 1), Map.entry("do", 2), Map.entry("di", 2), Map.entry("tri", 3), Map.entry("buta", 4), Map.entry("but", 4), Map.entry("tetra", 4), Map.entry("penta", 5), Map.entry("pent", 5), Map.entry("hexa", 6), Map.entry("hex", 6), Map.entry("hepta", 7), Map.entry("hept", 7), Map.entry("octa", 8), Map.entry("oct", 8), Map.entry("nona", 9), Map.entry("non", 9));
    private static final Map<String, Integer> SECOND_NUMBERS = Map.ofEntries(Map.entry("deca", 10), Map.entry("dec", 10), Map.entry("eicosa", 20), Map.entry("eicos", 20), Map.entry("cosa", 20), Map.entry("cos", 20), Map.entry("triaconta", 30), Map.entry("triacont", 30), Map.entry("tetraconta", 40), Map.entry("tetracont", 40), Map.entry("pentaconta", 50), Map.entry("pentacont", 50), Map.entry("hexaconta", 60), Map.entry("hexacont", 60), Map.entry("heptaconta", 70), Map.entry("heptacont", 70), Map.entry("octaconta", 80), Map.entry("octacont", 80), Map.entry("nonaconta", 90), Map.entry("nonacont", 90));
    private static final Map<String, String> FUNC_GROUPS = Map.ofEntries(Map.entry("keto", "oxo"), Map.entry("ethyl", "Et"), Map.entry("hydroxy", "OH"), Map.entry("phospho", "Ph"), Map.entry("oxo", "oxo"), Map.entry("bromo", "Br"), Map.entry("methyl", "Me"), Map.entry("hydroperoxy", "OOH"), Map.entry("homo", ""), Map.entry("Epoxy", "Ep"), Map.entry("fluro", "F"), Map.entry("fluoro", "F"), Map.entry("chloro", "Cl"), Map.entry("methylene", "My"), Map.entry("sulfooxy", "Su"), Map.entry("amino", "NH2"), Map.entry("sulfanyl", "SH"), Map.entry("methoxy", "OMe"), Map.entry("iodo", "I"), Map.entry("cyano", "CN"), Map.entry("nitro", "NO2"), Map.entry("OH", "OH"), Map.entry("thio", "SH"), Map.entry("mercapto", "SH"), Map.entry("carboxy", "COOH"), Map.entry("acetoxy", "Ac"), Map.entry("cysteinyl", "Cys"), Map.entry("phenyl", "Phe"), Map.entry("s-glutathionyl", "SGlu"), Map.entry("s-cysteinyl", "SCys"), Map.entry("butylperoxy", "BOO"), Map.entry("dimethylarsinoyl", "MMAs"), Map.entry("methylsulfanyl", "SMe"), Map.entry("imino", "NH"), Map.entry("s-cysteinylglycinyl", "SCG"));
    private static final Map<String, Integer> ATE = Map.ofEntries(Map.entry("formate", 1), Map.entry("acetate", 2), Map.entry("butyrate", 4), Map.entry("propionate", 3), Map.entry("valerate", 5), Map.entry("isobutyrate", 4));
    private static final Map<String, Integer> SPECIAL_NUMBERS = Map.ofEntries(Map.entry("meth", 1), Map.entry("etha", 2), Map.entry("eth", 2), Map.entry("propa", 3), Map.entry("isoprop", 3), Map.entry("prop", 3), Map.entry("propi", 3), Map.entry("propio", 3), Map.entry("buta", 4), Map.entry("but", 4), Map.entry("butr", 4), Map.entry("furan", 5), Map.entry("valer", 5), Map.entry("eicosa", 20), Map.entry("eicos", 20), Map.entry("icosa", 20), Map.entry("icos", 20), Map.entry("prosta", 20), Map.entry("prost", 20), Map.entry("prostan", 20));
    private static final Set<String> NOIC_SET = Set.of("noic acid", "nic acid", "dioic_acid");
    private static final Set<String> NAL_SET = Set.of("nal", "dial");
    private static final Set<String> ACETATE_SET = Set.of("acetate", "noate", "nate");

    public FattyAcidParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        this.knownFunctionalGroups = knownFunctionalGroups;
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("lipid_pre_event", this::resetParser), Map.entry("lipid_post_event", this::build_lipid), Map.entry("fatty_acid_post_event", this::set_fatty_acid), Map.entry("fatty_acid_recursion_post_event", this::set_fatty_acid), Map.entry("acid_single_type_pre_event", this::set_fatty_acyl_type), Map.entry("ol_ending_pre_event", this::set_fatty_acyl_type), Map.entry("double_bond_position_pre_event", this::set_double_bond_information), Map.entry("double_bond_position_post_event", this::add_double_bond_information), Map.entry("db_number_post_event", this::set_double_bond_position), Map.entry("cistrans_post_event", this::set_cistrans), Map.entry("acid_type_double_post_event", this::check_db), Map.entry("db_length_pre_event", this::open_db_length), Map.entry("db_length_post_event", this::close_db_length), Map.entry("functional_length_pre_event", this::reset_length), Map.entry("fatty_length_pre_event", this::reset_length), Map.entry("functional_length_post_event", this::set_functional_length), Map.entry("fatty_length_post_event", this::set_fatty_length), Map.entry("notation_specials_pre_event", this::special_number), Map.entry("notation_last_digit_pre_event", this::last_number), Map.entry("notation_second_digit_pre_event", this::second_number), Map.entry("functional_group_pre_event", this::set_functional_group), Map.entry("functional_group_post_event", this::add_functional_group), Map.entry("functional_pos_pre_event", this::set_functional_pos), Map.entry("functional_position_pre_event", this::set_functional_position), Map.entry("functional_group_type_pre_event", this::set_functional_type), Map.entry("cyclo_position_pre_event", this::set_functional_group), Map.entry("cyclo_position_post_event", this::rearrange_cycle), Map.entry("epoxy_pre_event", this::set_functional_group), Map.entry("epoxy_post_event", this::add_epoxy), Map.entry("cycle_pre_event", this::set_cycle), Map.entry("methylene_post_event", this::set_methylene), Map.entry("dioic_pre_event", this::set_functional_group), Map.entry("dioic_post_event", this::set_dioic), Map.entry("dioic_acid_pre_event", this::set_fatty_acyl_type), Map.entry("dial_post_event", this::set_dial), Map.entry("prosta_pre_event", this::set_prosta), Map.entry("prosta_post_event", this::add_cyclo), Map.entry("reduction_pre_event", this::set_functional_group), Map.entry("reduction_post_event", this::reduction), Map.entry("homo_post_event", this::homo), Map.entry("recursion_description_pre_event", this::set_recursion), Map.entry("recursion_description_post_event", this::add_recursion), Map.entry("recursion_pos_pre_event", this::set_recursion_pos), Map.entry("yl_ending_pre_event", this::set_yl_ending), Map.entry("acetic_acid_post_event", this::set_acetic_acid), Map.entry("acetic_recursion_pre_event", this::set_recursion), Map.entry("acetic_recursion_post_event", this::add_recursion), Map.entry("hydroxyl_number_pre_event", this::add_hydroxyl), Map.entry("ol_pre_event", this::setup_hydroxyl), Map.entry("ol_post_event", this::add_hydroxyls), Map.entry("ol_pos_post_event", this::set_yl_ending), Map.entry("wax_ester_pre_event", this::set_recursion), Map.entry("wax_ester_post_event", this::add_wax_ester), Map.entry("ate_post_event", this::set_ate), Map.entry("isoprop_post_event", this::set_iso), Map.entry("isobut_post_event", this::set_iso), Map.entry("coa_post_event", this::set_coa), Map.entry("methyl_pre_event", this::set_methyl), Map.entry("car_pre_event", this::set_car), Map.entry("car_post_event", this::add_car), Map.entry("tetrahydrofuran_pre_event", this::set_tetrahydrofuran), Map.entry("furan_pre_event", this::set_furan), Map.entry("ethanolamine_post_event", this::add_ethanolamine), Map.entry("amine_n_pre_event", this::set_recursion), Map.entry("amine_n_post_event", this::add_amine), Map.entry("amine_post_event", this::add_amine_name), Map.entry("fg_pos_summary_pre_event", this::set_functional_group), Map.entry("fg_pos_summary_post_event", this::add_summary), Map.entry("func_stereo_pre_event", this::add_func_stereo));
        }
        catch (Exception e) {
            throw new ConstraintViolationException("Cannot initialize FattyAcidParserEventHandler.", e);
        }
    }

    private String FA_I() {
        return "fa" + Integer.toString(this.fattyAcylStack.size());
    }

    private void set_lipid_level(LipidLevel _level) {
        this.level = this.level.level < _level.level ? this.level : _level;
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = null;
        this.level = LipidLevel.FULL_STRUCTURE;
        this.headgroup = "";
        this.fattyAcylStack = new ArrayDeque();
        this.fattyAcylStack.add(new FattyAcid("FA", this.knownFunctionalGroups));
        this.tmp = new Dictionary();
        this.tmp.put("fa1", new Dictionary());
    }

    void build_lipid(TreeNode node) {
        FattyAcid curr_fa;
        if (this.tmp.containsKey("cyclo_yl")) {
            this.tmp.put("fg_pos", new GenericList());
            GenericList l1 = new GenericList();
            l1.add(1);
            l1.add("");
            ((GenericList)this.tmp.get("fg_pos")).add(l1);
            GenericList l2 = new GenericList();
            l2.add(Integer.valueOf((Integer)this.tmp.get("cyclo_len")));
            l2.add("");
            ((GenericList)this.tmp.get("fg_pos")).add(l2);
            this.add_cyclo(node);
            this.tmp.remove("cyclo_yl");
            this.tmp.remove("cyclo_len");
        }
        if (this.tmp.containsKey("post_adding")) {
            FattyAcid curr_fa_p = this.fattyAcylStack.peekLast();
            int s = ((GenericList)this.tmp.get("post_adding")).size();
            curr_fa_p.setNumCarbon(curr_fa_p.getNumCarbon() + s);
            for (int i = 0; i < s; ++i) {
                int pos = (Integer)((GenericList)this.tmp.get("post_adding")).get(i);
                curr_fa_p.addPosition(pos);
                DoubleBonds db = new DoubleBonds(curr_fa_p.getDoubleBonds().getNumDoubleBonds());
                for (Map.Entry<Integer, String> kv : curr_fa_p.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                    db.getDoubleBondPositions().put(kv.getKey() + (kv.getKey() >= pos ? 1 : 0), kv.getValue());
                }
                db.setNumDoubleBonds(db.getDoubleBondPositions().size());
                curr_fa_p.setDoubleBonds(db);
            }
        }
        if ((curr_fa = this.fattyAcylStack.peekLast()).getDoubleBonds().getDoubleBondPositions().size() > 0) {
            int db_right = 0;
            for (Map.Entry<Integer, String> kv : curr_fa.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                db_right += kv.getValue().length() > 0 ? 1 : 0;
            }
            if (db_right != curr_fa.getDoubleBonds().getDoubleBondPositions().size()) {
                this.set_lipid_level(LipidLevel.STRUCTURE_DEFINED);
            }
        }
        Headgroup head_group = new Headgroup(this.headgroup);
        this.content = new LipidAdduct();
        switch (this.level) {
            case COMPLETE_STRUCTURE: {
                ((LipidAdduct)this.content).setLipid(new LipidCompleteStructure(head_group, this.fattyAcylStack, this.knownFunctionalGroups));
                break;
            }
            case FULL_STRUCTURE: {
                ((LipidAdduct)this.content).setLipid(new LipidFullStructure(head_group, this.fattyAcylStack, this.knownFunctionalGroups));
                break;
            }
            case STRUCTURE_DEFINED: {
                ((LipidAdduct)this.content).setLipid(new LipidStructureDefined(head_group, this.fattyAcylStack, this.knownFunctionalGroups));
                break;
            }
            case SN_POSITION: {
                ((LipidAdduct)this.content).setLipid(new LipidSnPosition(head_group, this.fattyAcylStack, this.knownFunctionalGroups));
                break;
            }
            case MOLECULAR_SPECIES: {
                ((LipidAdduct)this.content).setLipid(new LipidMolecularSpecies(head_group, this.fattyAcylStack, this.knownFunctionalGroups));
                break;
            }
            case SPECIES: {
                ((LipidAdduct)this.content).setLipid(new LipidSpecies(head_group, this.fattyAcylStack, this.knownFunctionalGroups));
                break;
            }
        }
    }

    void set_fatty_acyl_type(TreeNode node) {
        String t = node.getText();
        if (t.endsWith("ol")) {
            this.headgroup = "FOH";
        } else if (NOIC_SET.contains(t)) {
            this.headgroup = "FA";
        } else if (NAL_SET.contains(t)) {
            this.headgroup = "FAL";
        } else if (ACETATE_SET.contains(t)) {
            this.headgroup = "WE";
        } else if (t.equals("ne")) {
            this.headgroup = "HC";
            this.fattyAcylStack.peekLast().setLipidFaBondType(LipidFaBondType.ETHER);
        } else {
            this.headgroup = t;
        }
    }

    private void add_amine(TreeNode node) {
        FattyAcid fa = this.fattyAcylStack.pollLast();
        fa.setLipidFaBondType(LipidFaBondType.AMIDE);
        this.fattyAcylStack.getLast().setLipidFaBondType(LipidFaBondType.AMIDE);
        this.fattyAcylStack.addFirst(fa);
    }

    /*
     * WARNING - void declaration
     */
    private void set_fatty_acid(TreeNode node) {
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        if (this.tmp.containsKey("length_pattern")) {
            String length_pattern = (String)this.tmp.get("length_pattern");
            int[] num = new int[((GenericList)this.tmp.get("length_tokens")).size()];
            for (int i = 0; i < ((GenericList)this.tmp.get("length_tokens")).size(); ++i) {
                num[i] = (Integer)((GenericList)this.tmp.get("length_tokens")).get(i);
            }
            int l = 0;
            int d = 0;
            if (length_pattern.equals("L") || length_pattern.equals("S")) {
                l += num[0];
            } else if (length_pattern.equals("LS")) {
                l += num[0] + num[1];
            } else if (length_pattern.equals("LL") || length_pattern.equals("SL") || length_pattern.equals("SS")) {
                l += num[0];
                d += num[1];
            } else if (length_pattern.equals("LSL") || length_pattern.equals("LSS")) {
                l += num[0] + num[1];
                d += num[2];
            } else if (length_pattern.equals("LSLS")) {
                l += num[0] + num[1];
                d += num[2] + num[3];
            } else if (length_pattern.equals("SLS")) {
                l += num[0];
                d += num[1] + num[2];
            } else if (length_pattern.length() > 0 && length_pattern.charAt(0) == 'X') {
                void var7_21;
                l += num[0];
                boolean bl = true;
                while (var7_21 < ((GenericList)this.tmp.get("length_tokens")).size()) {
                    d += num[var7_21];
                    ++var7_21;
                }
            } else if (length_pattern.equals("LLS")) {
                throw new ConstraintViolationException("Cannot determine fatty acid and double bond length in '" + node.getText() + "'");
            }
            curr_fa.setNumCarbon(curr_fa.getNumCarbon() + l);
            if (curr_fa.getDoubleBonds().getDoubleBondPositions().isEmpty() && d > 0) {
                curr_fa.getDoubleBonds().setNumDoubleBonds(d);
            }
        }
        if (curr_fa.getFunctionalGroupsInternal().containsKey("noyloxy")) {
            if (this.headgroup.equals("FA")) {
                this.headgroup = "FAHFA";
            }
            while (curr_fa.getFunctionalGroupsInternal().get("noyloxy").size() > 0) {
                FattyAcid fa = (FattyAcid)curr_fa.getFunctionalGroupsInternal().get("noyloxy").get(curr_fa.getFunctionalGroupsInternal().get("noyloxy").size() - 1);
                curr_fa.getFunctionalGroupsInternal().get("noyloxy").remove(curr_fa.getFunctionalGroupsInternal().get("noyloxy").size() - 1);
                AcylAlkylGroup acyl = new AcylAlkylGroup(fa, this.knownFunctionalGroups);
                acyl.setPosition(fa.getPosition());
                if (!curr_fa.getFunctionalGroupsInternal().containsKey("acyl")) {
                    curr_fa.getFunctionalGroupsInternal().put("acyl", new ArrayList());
                }
                curr_fa.getFunctionalGroupsInternal().get("acyl").add(acyl);
            }
            curr_fa.getFunctionalGroupsInternal().remove("noyloxy");
        } else if (curr_fa.getFunctionalGroupsInternal().containsKey("nyloxy") || curr_fa.getFunctionalGroupsInternal().containsKey("yloxy")) {
            String yloxy;
            String string = yloxy = curr_fa.getFunctionalGroupsInternal().containsKey("nyloxy") ? "nyloxy" : "yloxy";
            while (curr_fa.getFunctionalGroupsInternal().get(yloxy).size() > 0) {
                FattyAcid fa = (FattyAcid)curr_fa.getFunctionalGroupsInternal().get(yloxy).get(curr_fa.getFunctionalGroupsInternal().get(yloxy).size() - 1);
                curr_fa.getFunctionalGroupsInternal().get(yloxy).remove(curr_fa.getFunctionalGroupsInternal().get(yloxy).size() - 1);
                AcylAlkylGroup alkyl = new AcylAlkylGroup(fa, -1, 1, true, this.knownFunctionalGroups);
                alkyl.setPosition(fa.getPosition());
                if (!curr_fa.getFunctionalGroupsInternal().containsKey("alkyl")) {
                    curr_fa.getFunctionalGroupsInternal().put("alkyl", new ArrayList());
                }
                curr_fa.getFunctionalGroupsInternal().get("alkyl").add(alkyl);
            }
            curr_fa.getFunctionalGroupsInternal().remove(yloxy);
        } else {
            boolean has_yl = false;
            for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : curr_fa.getFunctionalGroupsInternal().entrySet()) {
                if (!kv.getKey().endsWith("yl")) continue;
                has_yl = true;
                break;
            }
            if (has_yl) {
                while (true) {
                    String yl = "";
                    for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : curr_fa.getFunctionalGroupsInternal().entrySet()) {
                        if (!kv.getKey().endsWith("yl")) continue;
                        yl = kv.getKey();
                        break;
                    }
                    if (yl.length() == 0) break;
                    while (curr_fa.getFunctionalGroupsInternal().get(yl).size() > 0) {
                        FattyAcid fa = (FattyAcid)curr_fa.getFunctionalGroupsInternal().get(yl).get(curr_fa.getFunctionalGroupsInternal().get(yl).size() - 1);
                        curr_fa.getFunctionalGroupsInternal().get(yl).remove(curr_fa.getFunctionalGroupsInternal().get(yl).size() - 1);
                        if (this.tmp.containsKey("cyclo")) {
                            int cyclo_len = curr_fa.getNumCarbon();
                            this.tmp.put("cyclo_len", cyclo_len);
                            if (fa.getPosition() != cyclo_len && !this.tmp.containsKey("furan")) {
                                this.switch_position(curr_fa, 2 + cyclo_len);
                            }
                            fa.shiftPositions(cyclo_len);
                            if (this.tmp.containsKey("furan")) {
                                curr_fa.shiftPositions(-1);
                            }
                            for (Map.Entry<String, ArrayList<FunctionalGroup>> entry : fa.getFunctionalGroupsInternal().entrySet()) {
                                if (!curr_fa.getFunctionalGroupsInternal().containsKey(entry.getKey())) {
                                    curr_fa.getFunctionalGroupsInternal().put(entry.getKey(), new ArrayList());
                                }
                                for (FunctionalGroup func_group : entry.getValue()) {
                                    curr_fa.getFunctionalGroupsInternal().get(entry.getKey()).add(func_group);
                                }
                            }
                            curr_fa.setNumCarbon(cyclo_len + fa.getNumCarbon());
                            for (Map.Entry<Integer, String> entry : fa.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                                curr_fa.getDoubleBonds().getDoubleBondPositions().put(entry.getKey() + cyclo_len, entry.getValue());
                            }
                            curr_fa.getDoubleBonds().setNumDoubleBonds(curr_fa.getDoubleBonds().getDoubleBondPositions().size());
                            if (!this.tmp.containsKey("tetrahydrofuran") && this.tmp.containsKey("furan")) {
                                curr_fa.getDoubleBonds().setNumDoubleBonds(curr_fa.getDoubleBonds().getNumDoubleBonds() + 2);
                                if (!curr_fa.getDoubleBonds().getDoubleBondPositions().containsKey(1)) {
                                    curr_fa.getDoubleBonds().getDoubleBondPositions().put(1, "E");
                                }
                                if (!curr_fa.getDoubleBonds().getDoubleBondPositions().containsKey(3)) {
                                    curr_fa.getDoubleBonds().getDoubleBondPositions().put(3, "E");
                                }
                            }
                            this.tmp.put("cyclo_yl", true);
                            continue;
                        }
                        String fg_name = "";
                        if (fa.getDoubleBonds().getNumDoubleBonds() == 0 && fa.getFunctionalGroupsInternal().isEmpty()) {
                            void var7_27;
                            Object var7_24 = null;
                            if (fa.getNumCarbon() == 1) {
                                fg_name = "Me";
                                FunctionalGroup functionalGroup = this.knownFunctionalGroups.get(fg_name);
                            } else if (fa.getNumCarbon() == 2) {
                                fg_name = "Et";
                                FunctionalGroup functionalGroup = this.knownFunctionalGroups.get(fg_name);
                            }
                            if (var7_27 != null && fg_name.length() > 0) {
                                var7_27.setPosition(fa.getPosition());
                                if (!curr_fa.getFunctionalGroupsInternal().containsKey(fg_name)) {
                                    curr_fa.getFunctionalGroupsInternal().put(fg_name, new ArrayList());
                                }
                                curr_fa.getFunctionalGroupsInternal().get(fg_name).add((FunctionalGroup)var7_27);
                            }
                        }
                        if (fg_name.length() != 0) continue;
                        CarbonChain carbonChain = new CarbonChain(fa, fa.getPosition(), this.knownFunctionalGroups);
                        if (!curr_fa.getFunctionalGroupsInternal().containsKey("cc")) {
                            curr_fa.getFunctionalGroupsInternal().put("cc", new ArrayList());
                        }
                        curr_fa.getFunctionalGroupsInternal().get("cc").add(carbonChain);
                    }
                    if (this.tmp.containsKey("cyclo")) {
                        this.tmp.remove("cyclo");
                    }
                    curr_fa.getFunctionalGroupsInternal().remove(yl);
                }
            }
        }
        if (curr_fa.getFunctionalGroupsInternal().containsKey("cyclo")) {
            FattyAcid fa = (FattyAcid)curr_fa.getFunctionalGroupsInternal().get("cyclo").get(0);
            curr_fa.getFunctionalGroupsInternal().remove("cyclo");
            if (!this.tmp.containsKey("cyclo_len")) {
                this.tmp.put("cyclo_len", 5);
            }
            int start_pos = curr_fa.getNumCarbon() + 1;
            int end_pos = curr_fa.getNumCarbon() + (Integer)this.tmp.get("cyclo_len");
            fa.shiftPositions(start_pos - 1);
            if (curr_fa.getFunctionalGroupsInternal().containsKey("cy")) {
                for (FunctionalGroup functionalGroup : curr_fa.getFunctionalGroupsInternal().get("cy")) {
                    functionalGroup.shiftPositions(start_pos - 1);
                }
            }
            for (Map.Entry<String, ArrayList<FunctionalGroup>> entry : fa.getFunctionalGroupsInternal().entrySet()) {
                if (!curr_fa.getFunctionalGroupsInternal().containsKey(entry.getKey())) {
                    curr_fa.getFunctionalGroupsInternal().put(entry.getKey(), new ArrayList());
                }
                for (FunctionalGroup func_group : entry.getValue()) {
                    curr_fa.getFunctionalGroupsInternal().get(entry.getKey()).add(func_group);
                }
            }
            for (Map.Entry<Object, Object> entry : fa.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                curr_fa.getDoubleBonds().getDoubleBondPositions().put((Integer)entry.getKey() + start_pos - 1, (String)entry.getValue());
            }
            curr_fa.getDoubleBonds().setNumDoubleBonds(curr_fa.getDoubleBonds().getDoubleBondPositions().size());
            if (!this.tmp.containsKey("tetrahydrofuran") && this.tmp.containsKey("furan")) {
                curr_fa.getDoubleBonds().setNumDoubleBonds(curr_fa.getDoubleBonds().getNumDoubleBonds() + 2);
                if (!curr_fa.getDoubleBonds().getDoubleBondPositions().containsKey(1 + curr_fa.getNumCarbon())) {
                    curr_fa.getDoubleBonds().getDoubleBondPositions().put(1 + curr_fa.getNumCarbon(), "E");
                }
                if (!curr_fa.getDoubleBonds().getDoubleBondPositions().containsKey(3 + curr_fa.getNumCarbon())) {
                    curr_fa.getDoubleBonds().getDoubleBondPositions().put(3 + curr_fa.getNumCarbon(), "E");
                }
            }
            curr_fa.setNumCarbon(curr_fa.getNumCarbon() + fa.getNumCarbon());
            this.tmp.put("fg_pos", new GenericList());
            GenericList l1 = new GenericList();
            l1.add(start_pos);
            l1.add("");
            ((GenericList)this.tmp.get("fg_pos")).add(l1);
            GenericList genericList = new GenericList();
            genericList.add(end_pos);
            genericList.add("");
            ((GenericList)this.tmp.get("fg_pos")).add(genericList);
            this.add_cyclo(node);
            if (this.tmp.containsKey("cyclo_len")) {
                this.tmp.remove("cyclo_len");
            }
            if (this.tmp.containsKey("cyclo")) {
                this.tmp.remove("cyclo");
            }
        } else if (this.tmp.containsKey("cyclo")) {
            this.tmp.put("cyclo_yl", 1);
            this.tmp.put("cyclo_len", curr_fa.getNumCarbon());
            this.tmp.put("fg_pos", new GenericList());
            GenericList l1 = new GenericList();
            l1.add(1);
            l1.add("");
            ((GenericList)this.tmp.get("fg_pos")).add(l1);
            GenericList l2 = new GenericList();
            l2.add(curr_fa.getNumCarbon());
            l2.add("");
            ((GenericList)this.tmp.get("fg_pos")).add(l2);
            this.tmp.remove("cyclo");
        }
        this.tmp.put("length_pattern", "");
        this.tmp.put("length_tokens", new GenericList());
        this.tmp.put("add_lengths", 0);
    }

    private void switch_position(FunctionalGroup func_group, int switch_num) {
        func_group.setPosition(switch_num - func_group.getPosition());
        for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : func_group.getFunctionalGroupsInternal().entrySet()) {
            for (FunctionalGroup fg : kv.getValue()) {
                this.switch_position(fg, switch_num);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void add_cyclo(TreeNode node) {
        int start = (Integer)((GenericList)((GenericList)this.tmp.get("fg_pos")).get(0)).get(0);
        int end = (Integer)((GenericList)((GenericList)this.tmp.get("fg_pos")).get(1)).get(0);
        DoubleBonds cyclo_db = new DoubleBonds();
        if (this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().size() > 0) {
            for (Map.Entry<Integer, String> kv : this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().entrySet()) {
                if (start > kv.getKey() || kv.getKey() > end) continue;
                cyclo_db.getDoubleBondPositions().put(kv.getKey(), kv.getValue());
            }
            cyclo_db.setNumDoubleBonds(cyclo_db.getDoubleBondPositions().size());
            for (Map.Entry<Integer, String> kv : cyclo_db.getDoubleBondPositions().entrySet()) {
                this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().remove(kv.getKey());
            }
            this.fattyAcylStack.peekLast().getDoubleBonds().setNumDoubleBonds(this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().size());
        }
        HashMap<String, ArrayList<FunctionalGroup>> cyclo_fg = new HashMap<String, ArrayList<FunctionalGroup>>();
        HashSet<String> remove_list = new HashSet<String>();
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        if (curr_fa.getFunctionalGroupsInternal().containsKey("noyloxy")) {
            Iterator<Integer> remove_item = new ArrayList();
            boolean bl = false;
            for (FunctionalGroup func_group : curr_fa.getFunctionalGroupsInternal().get("noyloxy")) {
                void var9_10;
                if (start <= func_group.getPosition() && func_group.getPosition() <= end) {
                    CarbonChain cc = new CarbonChain((FattyAcid)func_group, func_group.getPosition(), this.knownFunctionalGroups);
                    if (!curr_fa.getFunctionalGroupsInternal().containsKey("cc")) {
                        curr_fa.getFunctionalGroupsInternal().put("cc", new ArrayList());
                    }
                    curr_fa.getFunctionalGroupsInternal().get("cc").add(cc);
                    ((ArrayList)((Object)remove_item)).add((int)var9_10);
                }
                ++var9_10;
            }
            for (int ii = ((ArrayList)((Object)remove_item)).size() - 1; ii >= 0; --ii) {
                curr_fa.getFunctionalGroupsInternal().get("noyloxy").remove((Integer)((ArrayList)((Object)remove_item)).get(ii));
            }
            if (curr_fa.getFunctionalGroupsInternal().get("noyloxy").isEmpty()) {
                remove_list.add("noyloxy");
            }
        }
        for (Map.Entry entry : curr_fa.getFunctionalGroupsInternal().entrySet()) {
            ArrayList<Integer> remove_item = new ArrayList<Integer>();
            int i = 0;
            for (FunctionalGroup func_group : (ArrayList)entry.getValue()) {
                if (start <= func_group.getPosition() && func_group.getPosition() <= end) {
                    if (!cyclo_fg.containsKey(entry.getKey())) {
                        cyclo_fg.put((String)entry.getKey(), new ArrayList());
                    }
                    cyclo_fg.get(entry.getKey()).add(func_group);
                    remove_item.add(i);
                }
                ++i;
            }
            for (int ii = remove_item.size() - 1; ii >= 0; --ii) {
                ((ArrayList)entry.getValue()).remove((Integer)remove_item.get(ii));
            }
            if (!((ArrayList)entry.getValue()).isEmpty()) continue;
            remove_list.add((String)entry.getKey());
        }
        for (String string : remove_list) {
            curr_fa.getFunctionalGroupsInternal().remove(string);
        }
        ArrayList<Element> bridge_chain = new ArrayList<Element>();
        if (this.tmp.containsKey("furan")) {
            this.tmp.remove("furan");
            bridge_chain.add(Element.O);
        }
        Cycle cycle = new Cycle(end - start + 1 + bridge_chain.size(), start, end, cyclo_db, cyclo_fg, bridge_chain, this.knownFunctionalGroups);
        if (!this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().containsKey("cy")) {
            this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().put("cy", new ArrayList());
        }
        this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().get("cy").add(cycle);
    }

    private void add_wax_ester(TreeNode node) {
        FattyAcid fa = this.fattyAcylStack.pollLast();
        fa.setLipidFaBondType(LipidFaBondType.ETHER);
        this.fattyAcylStack.addFirst(fa);
    }

    private void set_methyl(TreeNode node) {
        this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() + 1);
    }

    private void set_acetic_acid(TreeNode node) {
        this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() + 2);
        this.headgroup = "FA";
    }

    private void set_methylene(TreeNode node) {
        this.tmp.put("fg_type", "methylene");
        GenericList gl = (GenericList)this.tmp.get("fg_pos");
        if (gl.size() > 1) {
            if ((Integer)((GenericList)gl.get(0)).get(0) < (Integer)((GenericList)gl.get(1)).get(0)) {
                ((GenericList)gl.get(1)).set(0, (Integer)((GenericList)gl.get(1)).get(0) + 1);
            } else if ((Integer)((GenericList)gl.get(0)).get(0) > (Integer)((GenericList)gl.get(1)).get(0)) {
                ((GenericList)gl.get(0)).set(0, (Integer)((GenericList)gl.get(0)).get(0) + 1);
            }
            this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() + 1);
            this.tmp.put("add_methylene", 1);
        }
    }

    private void set_car(TreeNode node) {
        this.tmp.put("fg_pos", new GenericList());
        this.tmp.put("fg_type", "");
    }

    private void add_car(TreeNode node) {
        this.headgroup = "CAR";
    }

    private void add_ethanolamine(TreeNode node) {
        this.headgroup = "NAE";
    }

    private void add_amine_name(TreeNode node) {
        this.headgroup = "NA";
    }

    private void reset_length(TreeNode node) {
        this.tmp.put("length", 0);
        this.tmp.put("length_pattern", "");
        this.tmp.put("length_tokens", new GenericList());
        this.tmp.put("add_lengths", 1);
    }

    private void set_fatty_length(TreeNode node) {
        this.tmp.put("add_lengths", 0);
    }

    private void last_number(TreeNode node) {
        if ((Integer)this.tmp.get("add_lengths") == 1) {
            this.tmp.put("length", (Integer)this.tmp.get("length") + LAST_NUMBERS.get(node.getText()));
            this.tmp.put("length_pattern", (String)this.tmp.get("length_pattern") + "L");
            ((GenericList)this.tmp.get("length_tokens")).add(LAST_NUMBERS.get(node.getText()));
        }
    }

    private void second_number(TreeNode node) {
        if ((Integer)this.tmp.get("add_lengths") == 1) {
            this.tmp.put("length", (Integer)this.tmp.get("length") + SECOND_NUMBERS.get(node.getText()));
            this.tmp.put("length_pattern", (String)this.tmp.get("length_pattern") + "S");
            ((GenericList)this.tmp.get("length_tokens")).add(SECOND_NUMBERS.get(node.getText()));
        }
    }

    private void special_number(TreeNode node) {
        if ((Integer)this.tmp.get("add_lengths") == 1) {
            this.tmp.put("length", (Integer)this.tmp.get("length") + SPECIAL_NUMBERS.get(node.getText()));
            this.tmp.put("length_pattern", (String)this.tmp.get("length_pattern") + "X");
            ((GenericList)this.tmp.get("length_tokens")).add(SPECIAL_NUMBERS.get(node.getText()));
        }
    }

    private void set_iso(TreeNode node) {
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        curr_fa.setNumCarbon(curr_fa.getNumCarbon() - 1);
        FunctionalGroup fg = this.knownFunctionalGroups.get("Me");
        fg.setPosition(2);
        if (!curr_fa.getFunctionalGroupsInternal().containsKey("Me")) {
            curr_fa.getFunctionalGroupsInternal().put("Me", new ArrayList());
        }
        curr_fa.getFunctionalGroupsInternal().get("Me").add(fg);
    }

    private void set_prosta(TreeNode node) {
        int minus_pos = 0;
        if (this.tmp.containsKey("reduction")) {
            for (Object o : (GenericList)this.tmp.get("reduction")) {
                int i = (Integer)o;
                minus_pos += i < 8 ? 1 : 0;
            }
        }
        this.tmp.put("fg_pos", new GenericList());
        GenericList l1 = new GenericList();
        l1.add(8 - minus_pos);
        l1.add("");
        GenericList l2 = new GenericList();
        l2.add(12 - minus_pos);
        l2.add("");
        ((GenericList)this.tmp.get("fg_pos")).add(l1);
        ((GenericList)this.tmp.get("fg_pos")).add(l2);
        this.tmp.put("fg_type", "cy");
    }

    private void set_tetrahydrofuran(TreeNode node) {
        this.tmp.put("furan", 1);
        this.tmp.put("tetrahydrofuran", 1);
        this.set_cycle(node);
    }

    private void set_furan(TreeNode node) {
        this.tmp.put("furan", 1);
        this.set_cycle(node);
    }

    private void check_db(TreeNode node) {
        String fa_i = this.FA_I();
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        if (((Dictionary)this.tmp.get(fa_i)).containsKey("fg_pos_summary")) {
            for (Map.Entry kv : ((Dictionary)((Dictionary)this.tmp.get(fa_i)).get("fg_pos_summary")).entrySet()) {
                int k = Integer.valueOf((String)kv.getKey());
                String v = (String)((Dictionary)((Dictionary)this.tmp.get(fa_i)).get("fg_pos_summary")).get(kv.getKey());
                if (k <= 0 || curr_fa.getDoubleBonds().getDoubleBondPositions().containsKey(k) || !v.equals("E") && !v.equals("Z") && v.length() != 0) continue;
                curr_fa.getDoubleBonds().getDoubleBondPositions().put(k, v);
                curr_fa.getDoubleBonds().setNumDoubleBonds(curr_fa.getDoubleBonds().getDoubleBondPositions().size());
            }
        }
    }

    private void set_coa(TreeNode node) {
        this.headgroup = "CoA";
    }

    private void set_yl_ending(TreeNode node) {
        int l = Integer.valueOf(node.getText()) - 1;
        if (l == 0) {
            return;
        }
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        if (this.tmp.containsKey("furan")) {
            curr_fa.setNumCarbon(curr_fa.getNumCarbon() - l);
            return;
        }
        String fname = "";
        FunctionalGroup fg = null;
        if (l == 1) {
            fname = "Me";
            fg = this.knownFunctionalGroups.get(fname);
        } else if (l == 2) {
            fname = "Et";
            fg = this.knownFunctionalGroups.get(fname);
        } else {
            FattyAcid fa = new FattyAcid("FA", l, this.knownFunctionalGroups);
            for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : curr_fa.getFunctionalGroupsInternal().entrySet()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int i = 0;
                for (FunctionalGroup func_group : kv.getValue()) {
                    if (func_group.getPosition() > l) continue;
                    arrayList.add(i);
                    if (!fa.getFunctionalGroupsInternal().containsKey(kv.getKey())) {
                        fa.getFunctionalGroupsInternal().put(kv.getKey(), new ArrayList());
                    }
                    func_group.setPosition(l + 1 - func_group.getPosition());
                    fa.getFunctionalGroupsInternal().get(kv.getKey()).add(func_group);
                }
                for (int ii = arrayList.size() - 1; ii >= 0; --ii) {
                    curr_fa.getFunctionalGroupsInternal().get(kv.getKey()).remove((Integer)arrayList.get(ii));
                }
            }
            Map<String, ArrayList<FunctionalGroup>> func_dict = curr_fa.getFunctionalGroupsInternal();
            curr_fa.setFunctionalGroups(new HashMap<String, ArrayList<FunctionalGroup>>());
            for (Map.Entry<String, ArrayList<FunctionalGroup>> entry : func_dict.entrySet()) {
                if (entry.getValue().size() <= 0) continue;
                curr_fa.getFunctionalGroupsInternal().put(entry.getKey(), entry.getValue());
            }
            if (curr_fa.getDoubleBonds().getDoubleBondPositions().size() > 0) {
                fa.setDoubleBonds(new DoubleBonds());
                for (Map.Entry<Object, Object> entry : curr_fa.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                    if ((Integer)entry.getKey() > l) continue;
                    fa.getDoubleBonds().getDoubleBondPositions().put(l + 1 - (Integer)entry.getKey(), (String)entry.getValue());
                }
                fa.getDoubleBonds().setNumDoubleBonds(fa.getDoubleBonds().getDoubleBondPositions().size());
                for (Map.Entry<Object, Object> entry : fa.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                    curr_fa.getDoubleBonds().getDoubleBondPositions().remove(entry.getKey());
                }
            }
            fname = "cc";
            fg = new CarbonChain(fa, this.knownFunctionalGroups);
        }
        curr_fa.setNumCarbon(curr_fa.getNumCarbon() - l);
        fg.setPosition(l);
        curr_fa.shiftPositions(-l);
        if (!curr_fa.getFunctionalGroupsInternal().containsKey(fname)) {
            curr_fa.getFunctionalGroupsInternal().put(fname, new ArrayList());
        }
        curr_fa.getFunctionalGroupsInternal().get(fname).add(fg);
    }

    private void set_dial(TreeNode node) {
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        int pos = curr_fa.getNumCarbon();
        FunctionalGroup fg = this.knownFunctionalGroups.get("oxo");
        fg.setPosition(pos);
        if (!curr_fa.getFunctionalGroupsInternal().containsKey("oxo")) {
            curr_fa.getFunctionalGroupsInternal().put("oxo", new ArrayList());
        }
        curr_fa.getFunctionalGroupsInternal().get("oxo").add(fg);
    }

    private void open_db_length(TreeNode node) {
        this.tmp.put("add_lengths", 1);
    }

    private void close_db_length(TreeNode node) {
        this.tmp.put("add_lengths", 0);
    }

    private void set_dioic(TreeNode node) {
        int pos;
        this.headgroup = "FA";
        int n = pos = ((GenericList)this.tmp.get("fg_pos")).size() == 2 ? ((Integer)((GenericList)((GenericList)this.tmp.get("fg_pos")).get(1)).get(0)).intValue() : this.fattyAcylStack.peekLast().getNumCarbon();
        if (this.tmp.containsKey("reduction")) {
            pos -= ((GenericList)this.tmp.get("reduction")).size();
        }
        this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() - 1);
        FunctionalGroup func_group = this.knownFunctionalGroups.get("COOH");
        func_group.setPosition(pos - 1);
        if (!this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().containsKey("COOH")) {
            this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().put("COOH", new ArrayList());
        }
        this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().get("COOH").add(func_group);
    }

    private void setup_hydroxyl(TreeNode node) {
        this.tmp.put("hydroxyl_pos", new GenericList());
    }

    private void add_hydroxyls(TreeNode node) {
        if (((GenericList)this.tmp.get("hydroxyl_pos")).size() > 1) {
            FunctionalGroup fg_oh = this.knownFunctionalGroups.get("OH");
            ArrayList<Integer> sorted_pos = new ArrayList<Integer>();
            for (Object o : (GenericList)this.tmp.get("hydroxyl_pos")) {
                int i = (Integer)o;
                sorted_pos.add(i);
            }
            Collections.sort(sorted_pos, (a, b) -> b.compareTo((Integer)a));
            for (int i = 0; i < sorted_pos.size() - 1; ++i) {
                int pos = (Integer)sorted_pos.get(i);
                FunctionalGroup fg_insert = fg_oh.copy();
                fg_insert.setPosition(pos);
                if (!this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().containsKey("OH")) {
                    this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().put("OH", new ArrayList());
                }
                this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().get("OH").add(fg_insert);
            }
        }
    }

    private void set_ate(TreeNode node) {
        this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() + ATE.get(node.getText()));
        this.headgroup = "WE";
    }

    private void add_hydroxyl(TreeNode node) {
        int h = Integer.valueOf(node.getText());
        ((GenericList)this.tmp.get("hydroxyl_pos")).add(h);
    }

    private void set_functional_group(TreeNode node) {
        this.tmp.put("fg_pos", new GenericList());
        this.tmp.put("fg_type", "");
    }

    private void add_functional_group(TreeNode node) {
        if (this.tmp.containsKey("added_func_group")) {
            this.tmp.remove("added_func_group");
            return;
        }
        if (this.tmp.containsKey("add_methylene")) {
            this.tmp.remove("add_methylene");
            this.add_cyclo(node);
            return;
        }
        String t = (String)this.tmp.get("fg_type");
        FunctionalGroup fg = null;
        if (!t.equals("acetoxy")) {
            if (!FUNC_GROUPS.containsKey(t)) {
                throw new LipidException("Unknown functional group: '" + t + "'");
            }
            if ((t = FUNC_GROUPS.get(t)).length() == 0) {
                return;
            }
            fg = this.knownFunctionalGroups.get(t);
        } else {
            fg = new AcylAlkylGroup(new FattyAcid("O", 2, this.knownFunctionalGroups), this.knownFunctionalGroups);
        }
        FattyAcid fa = this.fattyAcylStack.peekLast();
        if (!fa.getFunctionalGroupsInternal().containsKey(t)) {
            fa.getFunctionalGroupsInternal().put(t, new ArrayList());
        }
        int l = ((GenericList)this.tmp.get("fg_pos")).size();
        for (Object o : (GenericList)this.tmp.get("fg_pos")) {
            GenericList lst = (GenericList)o;
            int pos = (Integer)lst.get(0);
            int num_pos = 0;
            if (this.tmp.containsKey("reduction")) {
                for (Object oo : (GenericList)this.tmp.get("reduction")) {
                    int i = (Integer)oo;
                    num_pos += i < pos ? 1 : 0;
                }
            }
            FunctionalGroup fg_insert = fg.copy();
            fg_insert.setPosition(pos - num_pos);
            fa.getFunctionalGroupsInternal().get(t).add(fg_insert);
        }
    }

    private void set_double_bond_information(TreeNode node) {
        ((Dictionary)this.tmp.get(this.FA_I())).put("db_position", 0);
        ((Dictionary)this.tmp.get(this.FA_I())).put("db_cistrans", "");
    }

    private void add_double_bond_information(TreeNode node) {
        int pos = (Integer)((Dictionary)this.tmp.get(this.FA_I())).get("db_position");
        String str_pos = Integer.toString(pos);
        String cistrans = (String)((Dictionary)this.tmp.get(this.FA_I())).get("db_cistrans");
        if (cistrans.length() == 0 && ((Dictionary)this.tmp.get(this.FA_I())).containsKey("fg_pos_summary") && ((Dictionary)((Dictionary)this.tmp.get(this.FA_I())).get("fg_pos_summary")).containsKey(str_pos)) {
            cistrans = (String)((Dictionary)((Dictionary)this.tmp.get(this.FA_I())).get("fg_pos_summary")).get(str_pos);
        }
        if (pos == 0) {
            return;
        }
        cistrans = cistrans.toUpperCase();
        ((Dictionary)this.tmp.get(this.FA_I())).remove("db_position");
        ((Dictionary)this.tmp.get(this.FA_I())).remove("db_cistrans");
        if (!cistrans.equals("E") && !cistrans.equals("Z")) {
            cistrans = "";
        }
        if (!this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().containsKey(pos) || this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().get(pos).length() == 0) {
            this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().put(pos, cistrans);
            this.fattyAcylStack.peekLast().getDoubleBonds().setNumDoubleBonds(this.fattyAcylStack.peekLast().getDoubleBonds().getDoubleBondPositions().size());
        }
    }

    private void set_cistrans(TreeNode node) {
        ((Dictionary)this.tmp.get(this.FA_I())).put("db_cistrans", node.getText());
    }

    private void set_double_bond_position(TreeNode node) {
        int pos = Integer.valueOf(node.getText());
        int num_db = 0;
        if (this.tmp.containsKey("reduction")) {
            GenericList gl = (GenericList)this.tmp.get("reduction");
            int l = gl.size();
            for (int i = 0; i < l; ++i) {
                num_db += (Integer)gl.get(i) < pos ? 1 : 0;
            }
        }
        ((Dictionary)this.tmp.get(this.FA_I())).put("db_position", pos - num_db);
    }

    private void add_summary(TreeNode node) {
        String fa_i = this.FA_I();
        ((Dictionary)this.tmp.get(fa_i)).put("fg_pos_summary", new Dictionary());
        for (Object o : (GenericList)this.tmp.get("fg_pos")) {
            GenericList lst = (GenericList)o;
            String k = Integer.toString((Integer)lst.get(0));
            String v = ((String)lst.get(1)).toUpperCase();
            ((Dictionary)((Dictionary)this.tmp.get(fa_i)).get("fg_pos_summary")).put(k, v);
        }
    }

    private void set_functional_length(TreeNode node) {
        if (((Integer)this.tmp.get("length")).intValue() != ((GenericList)this.tmp.get("fg_pos")).size()) {
            throw new LipidException("Length of functional group '" + Integer.toString((Integer)this.tmp.get("length")) + "' does not match with number of its positions '" + Integer.toString(((GenericList)this.tmp.get("fg_pos")).size()) + "'");
        }
    }

    private void set_functional_type(TreeNode node) {
        this.tmp.put("fg_type", node.getText());
    }

    private void add_epoxy(TreeNode node) {
        GenericList gl = (GenericList)this.tmp.get("fg_pos");
        while (gl.size() > 1) {
            gl.remove(gl.size() - 1);
        }
        this.tmp.put("fg_type", "Epoxy");
    }

    private void set_functional_position(TreeNode node) {
        GenericList gl = new GenericList();
        gl.add(0);
        gl.add("");
        ((GenericList)this.tmp.get("fg_pos")).add(gl);
    }

    private void set_functional_pos(TreeNode node) {
        GenericList gl = (GenericList)this.tmp.get("fg_pos");
        ((GenericList)gl.get(gl.size() - 1)).set(0, Integer.valueOf(node.getText()));
    }

    private void add_func_stereo(TreeNode node) {
        int l = ((GenericList)this.tmp.get("fg_pos")).size();
        ((GenericList)((GenericList)this.tmp.get("fg_pos")).get(l - 1)).set(1, node.getText());
    }

    private void reduction(TreeNode node) {
        int shift_len = -((GenericList)this.tmp.get("fg_pos")).size();
        this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() + shift_len);
        for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : this.fattyAcylStack.peekLast().getFunctionalGroupsInternal().entrySet()) {
            for (FunctionalGroup func_group : kv.getValue()) {
                func_group.shiftPositions(shift_len);
            }
        }
        this.tmp.put("reduction", new GenericList());
        for (Map.Entry<String, ArrayList<FunctionalGroup>> o : (GenericList)this.tmp.get("fg_pos")) {
            GenericList lst = (GenericList)((Object)o);
            ((GenericList)this.tmp.get("reduction")).add(Integer.valueOf((Integer)lst.get(0)));
        }
    }

    private void homo(TreeNode node) {
        this.tmp.put("post_adding", new GenericList());
        for (Object o : (GenericList)this.tmp.get("fg_pos")) {
            GenericList lst = (GenericList)o;
            ((GenericList)this.tmp.get("post_adding")).add(Integer.valueOf((Integer)lst.get(0)));
        }
    }

    private void set_cycle(TreeNode node) {
        this.tmp.put("cyclo", 1);
    }

    private void rearrange_cycle(TreeNode node) {
        if (this.tmp.containsKey("post_adding")) {
            this.fattyAcylStack.peekLast().setNumCarbon(this.fattyAcylStack.peekLast().getNumCarbon() + ((GenericList)this.tmp.get("post_adding")).size());
            this.tmp.remove("post_adding");
        }
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        int start = (Integer)((GenericList)((GenericList)this.tmp.get("fg_pos")).get(0)).get(0);
        if (curr_fa.getFunctionalGroupsInternal().containsKey("cy")) {
            for (FunctionalGroup cy : curr_fa.getFunctionalGroupsInternal().get("cy")) {
                int shift_val = start - cy.getPosition();
                if (shift_val == 0) continue;
                ((Cycle)cy).rearrangeFunctionalGroups(curr_fa, shift_val);
            }
        }
    }

    private void set_recursion(TreeNode node) {
        this.tmp.put("fg_pos", new GenericList());
        this.tmp.put("fg_type", "");
        this.fattyAcylStack.add(new FattyAcid("FA", this.knownFunctionalGroups));
        this.tmp.put(this.FA_I(), new Dictionary());
        ((Dictionary)this.tmp.get(this.FA_I())).put("recursion_pos", 0);
    }

    private void add_recursion(TreeNode node) {
        int pos = (Integer)((Dictionary)this.tmp.get(this.FA_I())).get("recursion_pos");
        FattyAcid fa = this.fattyAcylStack.pollLast();
        fa.setPosition(pos);
        FattyAcid curr_fa = this.fattyAcylStack.peekLast();
        String fname = "";
        if (this.tmp.containsKey("cyclo_yl")) {
            fname = "cyclo";
            this.tmp.remove("cyclo_yl");
        } else {
            fname = this.headgroup;
        }
        if (!curr_fa.getFunctionalGroupsInternal().containsKey(fname)) {
            curr_fa.getFunctionalGroupsInternal().put(fname, new ArrayList());
        }
        curr_fa.getFunctionalGroupsInternal().get(fname).add(fa);
        this.tmp.put("added_func_group", 1);
    }

    private void set_recursion_pos(TreeNode node) {
        ((Dictionary)this.tmp.get(this.FA_I())).put("recursion_pos", Integer.valueOf(node.getText()));
    }
}

