/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.domain.StringFunctions;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;
import org.lifstools.jgoslin.parser.Bitfield;
import org.lifstools.jgoslin.parser.TreeNode;

public abstract class Parser<T> {
    protected static final int SHIFT = 32;
    protected static final long MASK = 0xFFFFFFFFL;
    protected static final char RULE_ASSIGNMENT = ':';
    protected static final char RULE_SEPARATOR = '|';
    protected static final char RULE_TERMINAL = ';';
    protected static final char EOF_SIGN = '\u0001';
    protected static final long EOF_RULE = 1L;
    protected static final long START_RULE = 2L;
    protected static final String EOF_RULE_NAME = "EOF";
    protected long nextFreeRuleIndex;
    protected final HashMap<Character, HashSet<Long>> TtoNT = new HashMap();
    protected final HashMap<Character, Long> originalTtoNT = new HashMap();
    protected final HashMap<String, Long> ruleToNT = new HashMap();
    protected final HashMap<Long, HashSet<Long>> NTtoNT = new HashMap();
    protected final HashMap<Long, String> NTtoRule = new HashMap();
    protected final HashMap<Long, ArrayList<Long>> substitution = new HashMap();
    protected final ArrayList<Bitfield> rightPair = new ArrayList();
    protected int avgPair;
    protected char quote;
    protected String grammarName = "";
    protected boolean usedEof = false;
    protected static final char DEFAULT_QUOTE = '\'';

    public Parser(String grammarContent) {
        this(grammarContent, '\u0000');
    }

    public Parser(String grammarContent, char _quote) {
        this.quote = (char)(_quote != 0 ? _quote : 39);
        this.readGrammar(grammarContent);
    }

    public abstract BaseParserEventHandler<T> newEventHandler();

    protected long get_next_free_rule_index() {
        if (this.nextFreeRuleIndex <= 0xFFFFFFFFL) {
            return this.nextFreeRuleIndex++;
        }
        throw new ConstraintViolationException("Error: grammar is too big.");
    }

    protected final void readGrammar(String grammar) {
        Object non_terminal_rules;
        ArrayList<String> rule_tokens;
        this.nextFreeRuleIndex = 2L;
        this.grammarName = "";
        this.usedEof = false;
        ArrayList<String> rules = this.extract_text_based_rules(grammar, this.quote);
        ArrayList<String> tokens = StringFunctions.splitString(rules.get(0), ' ', this.quote);
        this.grammarName = tokens.get(1);
        rules.remove(0);
        this.ruleToNT.put(EOF_RULE_NAME, 1L);
        this.TtoNT.put(Character.valueOf('\u0001'), new HashSet());
        this.TtoNT.get(Character.valueOf('\u0001')).add(1L);
        for (String string : rules) {
            long new_rule_index;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = StringFunctions.splitString(string, ':', this.quote);
            for (String t : arrayList2) {
                arrayList.add(StringFunctions.strip(t, ' '));
            }
            if (arrayList.size() != 2) {
                throw new ConstraintViolationException("Error: corrupted token in grammar rule: '" + string + "'");
            }
            rule_tokens = StringFunctions.splitString((String)arrayList.get(0), ' ', this.quote);
            if (rule_tokens.size() > 1) {
                throw new ConstraintViolationException("Error: several rule names on left hand side in grammar rule: '" + string + "'");
            }
            String rule = (String)arrayList.get(0);
            if (rule.equals(EOF_RULE_NAME)) {
                throw new ConstraintViolationException("Error: rule name is not allowed to be called EOF");
            }
            ArrayList<String> products = StringFunctions.splitString((String)arrayList.get(1), '|', this.quote);
            for (int i = 0; i < products.size(); ++i) {
                products.set(i, StringFunctions.strip(products.get(i), ' '));
            }
            if (!this.ruleToNT.containsKey(rule)) {
                this.ruleToNT.put(rule, this.get_next_free_rule_index());
            }
            if (!this.NTtoRule.containsKey(new_rule_index = this.ruleToNT.get(rule).longValue())) {
                this.NTtoRule.put(new_rule_index, rule);
            }
            for (String product : products) {
                long key;
                long rule_index_1;
                ArrayList<String> non_terminals = new ArrayList<String>();
                non_terminal_rules = new ArrayDeque();
                ArrayList<String> product_rules = StringFunctions.splitString(product, ' ', this.quote);
                for (String string2 : product_rules) {
                    String stripedNT = StringFunctions.strip(string2, ' ');
                    if (this.is_terminal(stripedNT, this.quote)) {
                        stripedNT = this.de_escape(stripedNT, this.quote);
                    }
                    non_terminals.add(stripedNT);
                    this.usedEof |= stripedNT.equals(EOF_RULE_NAME);
                }
                String NTFirst = (String)non_terminals.get(0);
                if (non_terminals.size() > 1 || !this.is_terminal(NTFirst, this.quote) || NTFirst.length() != 3) {
                    for (String non_terminal : non_terminals) {
                        if (this.is_terminal(non_terminal, this.quote)) {
                            ((ArrayDeque)non_terminal_rules).add(this.add_terminal(non_terminal));
                            continue;
                        }
                        if (!this.ruleToNT.containsKey(non_terminal)) {
                            this.ruleToNT.put(non_terminal, this.get_next_free_rule_index());
                        }
                        ((ArrayDeque)non_terminal_rules).add(this.ruleToNT.get(non_terminal));
                    }
                } else {
                    char c = NTFirst.charAt(1);
                    long tRule = 0L;
                    if (!this.TtoNT.containsKey(Character.valueOf(c))) {
                        tRule = this.get_next_free_rule_index();
                        this.TtoNT.put(Character.valueOf(c), new HashSet());
                        this.TtoNT.get(Character.valueOf(c)).add(tRule);
                    } else {
                        tRule = (Long)new ArrayList(this.TtoNT.get(Character.valueOf(c))).get(0);
                    }
                    if (!this.NTtoNT.containsKey(tRule)) {
                        this.NTtoNT.put(tRule, new HashSet());
                    }
                    this.NTtoNT.get(tRule).add(new_rule_index);
                }
                while (((ArrayDeque)non_terminal_rules).size() > 2) {
                    long l = (Long)((ArrayDeque)non_terminal_rules).pollLast();
                    rule_index_1 = (Long)((ArrayDeque)non_terminal_rules).pollLast();
                    key = this.compute_rule_key(rule_index_1, l);
                    long next_index = this.get_next_free_rule_index();
                    if (!this.NTtoNT.containsKey(key)) {
                        this.NTtoNT.put(key, new HashSet());
                    }
                    this.NTtoNT.get(key).add(next_index);
                    ((ArrayDeque)non_terminal_rules).add(next_index);
                }
                if (((ArrayDeque)non_terminal_rules).size() == 2) {
                    long l = (Long)((ArrayDeque)non_terminal_rules).pollLast();
                    rule_index_1 = (Long)((ArrayDeque)non_terminal_rules).pollLast();
                    key = this.compute_rule_key(rule_index_1, l);
                    if (!this.NTtoNT.containsKey(key)) {
                        this.NTtoNT.put(key, new HashSet());
                    }
                    this.NTtoNT.get(key).add(new_rule_index);
                    continue;
                }
                if (((ArrayDeque)non_terminal_rules).size() != 1) continue;
                long l = (Long)((ArrayDeque)non_terminal_rules).pollLast();
                if (l == new_rule_index) {
                    throw new ConstraintViolationException("Error: corrupted token in grammar: rule '" + rule + "' is not allowed to refer soleley to itself.");
                }
                if (!this.NTtoNT.containsKey(l)) {
                    this.NTtoNT.put(l, new HashSet());
                }
                this.NTtoNT.get(l).add(new_rule_index);
            }
        }
        for (Map.Entry entry : this.TtoNT.entrySet()) {
            Iterator iterator = ((HashSet)entry.getValue()).iterator();
            if (!iterator.hasNext()) continue;
            long l = (Long)iterator.next();
            this.originalTtoNT.put((Character)entry.getKey(), l);
        }
        HashSet<Long> visited = new HashSet<Long>();
        for (Map.Entry<Long, HashSet<Long>> entry : this.NTtoNT.entrySet()) {
            HashSet<Long> hashSet = new HashSet<Long>();
            hashSet.add(entry.getKey());
            rule_tokens = hashSet.iterator();
            while (rule_tokens.hasNext()) {
                long rule = (Long)rule_tokens.next();
                if (visited.contains(rule)) continue;
                visited.add(rule);
                ArrayList<Long> topnodes = this.collect_one_backwards(rule);
                for (long rule_top : topnodes) {
                    ArrayList<ArrayList<Long>> chains = this.collect_backwards(rule, rule_top);
                    non_terminal_rules = chains.iterator();
                    block11: while (non_terminal_rules.hasNext()) {
                        ArrayList<Long> cchain;
                        ArrayList<Long> chain = cchain = non_terminal_rules.next();
                        while (chain.size() > 1) {
                            long l = chain.get(0);
                            chain.remove(0);
                            long key = entry.getKey() + (l << 16);
                            if (this.substitution.containsKey(key)) continue block11;
                            this.substitution.put(key, chain);
                            if (chain.size() <= 1) continue;
                            ArrayList<Long> new_chain = new ArrayList<Long>();
                            for (long e : chain) {
                                new_chain.add(e);
                            }
                            chain = new_chain;
                        }
                    }
                }
            }
        }
        HashSet<Character> hashSet = new HashSet<Character>();
        for (Map.Entry<Character, HashSet<Long>> entry : this.TtoNT.entrySet()) {
            hashSet.add(entry.getKey());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            HashSet<Long> k_rules = new HashSet<Long>();
            for (long rule : this.TtoNT.get(Character.valueOf(c))) {
                k_rules.add(rule);
            }
            for (long rule : k_rules) {
                ArrayList<Long> backward_rules = this.collect_one_backwards(rule);
                for (long p : backward_rules) {
                    this.TtoNT.get(Character.valueOf(c)).add(p);
                }
            }
        }
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Map.Entry<Long, HashSet<Long>> k : this.NTtoNT.entrySet()) {
            hashSet2.add(k.getKey());
        }
        Iterator iterator2 = hashSet2.iterator();
        while (iterator2.hasNext()) {
            long r = (Long)iterator2.next();
            HashSet<Long> k_rules = new HashSet<Long>();
            for (long rr : this.NTtoNT.get(r)) {
                k_rules.add(rr);
            }
            for (long rule : k_rules) {
                ArrayList<Long> backward_rules = this.collect_one_backwards(rule);
                for (long p : backward_rules) {
                    this.NTtoNT.get(r).add(p);
                }
            }
        }
        for (long i = 0L; i < this.nextFreeRuleIndex; ++i) {
            this.rightPair.add(new Bitfield((int)this.nextFreeRuleIndex));
        }
        for (Map.Entry<Long, HashSet<Long>> kv4 : this.NTtoNT.entrySet()) {
            if (kv4.getKey() <= 0xFFFFFFFFL) continue;
            this.rightPair.get((int)(kv4.getKey() >>> 32)).add((int)(kv4.getKey() & 0xFFFFFFFFL));
        }
    }

    protected ArrayList<String> extract_text_based_rules(String grammar, char _quote) {
        ArrayList<String> rules = null;
        int grammar_length = grammar.length();
        StringBuilder sb = new StringBuilder();
        Context current_context = Context.NoContext;
        int current_position = 0;
        int last_escaped_backslash = -1;
        block11: for (int i = 0; i < grammar_length - 1; ++i) {
            MatchWords match = MatchWords.NoMatch;
            if (i > 0 && grammar.charAt(i) == '\\' && grammar.charAt(i - 1) == '\\' && last_escaped_backslash != i - 1) {
                last_escaped_backslash = i;
                continue;
            }
            if (grammar.charAt(i) == '/' && grammar.charAt(i + 1) == '/') {
                match = MatchWords.LineCommentStart;
            } else if (grammar.charAt(i) == '\n') {
                match = MatchWords.LineCommentEnd;
            } else if (grammar.charAt(i) == '/' && grammar.charAt(i + 1) == '*') {
                match = MatchWords.LongCommentStart;
            } else if (grammar.charAt(i) == '*' && grammar.charAt(i + 1) == '/') {
                match = MatchWords.LongCommentEnd;
            } else if (grammar.charAt(i) == _quote && (i < 1 || grammar.charAt(i - 1) != '\\' || i - 1 == last_escaped_backslash)) {
                match = MatchWords.Quote;
            }
            if (match == MatchWords.NoMatch) continue;
            switch (current_context) {
                case NoContext: {
                    switch (match) {
                        case LongCommentStart: {
                            sb.append(grammar.substring(current_position, i));
                            current_context = Context.InLongComment;
                            continue block11;
                        }
                        case LineCommentStart: {
                            sb.append(grammar.substring(current_position, i));
                            current_context = Context.InLineComment;
                            continue block11;
                        }
                        case Quote: {
                            current_context = Context.InQuote;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case InQuote: {
                    if (match != MatchWords.Quote) continue block11;
                    current_context = Context.NoContext;
                    continue block11;
                }
                case InLineComment: {
                    if (match != MatchWords.LineCommentEnd) continue block11;
                    current_context = Context.NoContext;
                    current_position = i + 1;
                    continue block11;
                }
                case InLongComment: {
                    if (match != MatchWords.LongCommentEnd) continue block11;
                    current_context = Context.NoContext;
                    current_position = i + 2;
                    continue block11;
                }
            }
        }
        if (current_context != Context.NoContext) {
            throw new ConstraintViolationException("Error: corrupted grammar, ends either in comment or quote");
        }
        sb.append(grammar.substring(current_position, grammar_length));
        grammar = sb.toString();
        grammar = grammar.replace("\r\n", "");
        grammar = grammar.replace("\n", "");
        grammar = grammar.replace("\r", "");
        grammar = StringFunctions.strip(grammar, ' ');
        if (grammar.charAt(grammar.length() - 1) != ';') {
            throw new ConstraintViolationException("Error: corrupted grammar, last rule has no termininating sign, was: '" + grammar.substring(grammar.length() - 1) + "'");
        }
        rules = StringFunctions.splitString(grammar, ';', _quote);
        if (rules.size() < 1) {
            throw new ConstraintViolationException("Error: corrupted grammar, grammar is empty");
        }
        ArrayList<String> grammar_name_rule = StringFunctions.splitString(rules.get(0), ' ', _quote);
        if (grammar_name_rule.size() > 0 && !grammar_name_rule.get(0).equals("grammar")) {
            throw new ConstraintViolationException("Error: first rule must start with the keyword 'grammar'");
        }
        if (grammar_name_rule.size() != 2) {
            throw new ConstraintViolationException("Error: incorrect first rule");
        }
        return rules;
    }

    protected long compute_rule_key(long rule_index_1, long rule_index_2) {
        return rule_index_1 << 32 | rule_index_2;
    }

    protected boolean is_terminal(String product_token, char _quote) {
        return product_token.charAt(0) == _quote && product_token.charAt(product_token.length() - 1) == _quote && product_token.length() > 2;
    }

    protected String de_escape(String text, char _quote) {
        StringBuilder sb = new StringBuilder();
        boolean last_escape_char = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean escape_char = false;
            if (c != '\\') {
                sb.append(c);
            } else if (!last_escape_char) {
                escape_char = true;
            } else {
                sb.append(c);
            }
            last_escape_char = escape_char;
        }
        return sb.toString();
    }

    protected long add_terminal(String text) {
        ArrayDeque<Long> terminal_rules = new ArrayDeque<Long>();
        for (int i = 1; i < text.length() - 1; ++i) {
            char c = text.charAt(i);
            long tRule = 0L;
            if (!this.TtoNT.containsKey(Character.valueOf(c))) {
                tRule = this.get_next_free_rule_index();
                this.TtoNT.put(Character.valueOf(c), new HashSet());
                this.TtoNT.get(Character.valueOf(c)).add(tRule);
            } else {
                tRule = (Long)new ArrayList(this.TtoNT.get(Character.valueOf(c))).get(0);
            }
            terminal_rules.add(tRule);
        }
        while (terminal_rules.size() > 1) {
            long rule_index_2 = (Long)terminal_rules.pollLast();
            long rule_index_1 = (Long)terminal_rules.pollLast();
            long next_index = this.get_next_free_rule_index();
            long key = this.compute_rule_key(rule_index_1, rule_index_2);
            if (!this.NTtoNT.containsKey(key)) {
                this.NTtoNT.put(key, new HashSet());
            }
            this.NTtoNT.get(key).add(next_index);
            terminal_rules.add(next_index);
        }
        return (Long)terminal_rules.pollLast();
    }

    protected ArrayList<Long> top_nodes(long rule_index) {
        ArrayList<Long> collection = new ArrayList<Long>();
        ArrayList<Long> collection_top = new ArrayList<Long>();
        collection.add(rule_index);
        for (int i = 0; i < collection.size(); ++i) {
            long current_index = (Long)collection.get(i);
            if (!this.NTtoNT.containsKey(current_index)) {
                for (long previous_index : this.NTtoNT.get(current_index)) {
                    collection.add(previous_index);
                }
                continue;
            }
            collection_top.add(current_index);
        }
        return collection_top;
    }

    protected ArrayList<Long> collect_one_backwards(Long rule_index) {
        ArrayList<Long> collection = new ArrayList<Long>();
        collection.add(rule_index);
        for (int i = 0; i < collection.size(); ++i) {
            long current_index = collection.get(i);
            if (!this.NTtoNT.containsKey(current_index)) continue;
            for (long previous_index : this.NTtoNT.get(current_index)) {
                collection.add(previous_index);
            }
        }
        return collection;
    }

    protected ArrayList<ArrayList<Long>> collect_backwards(Long child_rule_index, Long parent_rule_index) {
        HashSet<Long> visited = new HashSet<Long>();
        ArrayList<Long> path = new ArrayList<Long>();
        ArrayList<ArrayList<Long>> collection = new ArrayList<ArrayList<Long>>();
        return this.collect_backwards(child_rule_index, parent_rule_index, visited, path, collection);
    }

    protected ArrayList<ArrayList<Long>> collect_backwards(long child_rule_index, long parent_rule_index, HashSet<Long> visited, ArrayList<Long> path, ArrayList<ArrayList<Long>> collection) {
        if (!this.NTtoNT.containsKey(child_rule_index)) {
            return collection;
        }
        visited.add(child_rule_index);
        path.add(child_rule_index);
        for (long previous_rule : this.NTtoNT.get(child_rule_index)) {
            if (visited.contains(previous_rule)) continue;
            if (previous_rule == parent_rule_index) {
                ArrayList<Long> found_path = new ArrayList<Long>();
                found_path.add(parent_rule_index);
                for (int i = path.size() - 1; i >= 0; --i) {
                    found_path.add(path.get(i));
                }
                collection.add(found_path);
                continue;
            }
            collection = this.collect_backwards(previous_rule, parent_rule_index, visited, path, collection);
        }
        path.remove(path.size() - 1);
        visited.remove(child_rule_index);
        return collection;
    }

    protected void raise_events(TreeNode node, BaseParserEventHandler parserEventHandler) {
        if (node != null) {
            String node_rule_name;
            String string = node_rule_name = node.fire_event ? this.NTtoRule.get(node.rule_index) : "";
            if (node.fire_event) {
                parserEventHandler.handleEvent(node_rule_name + "_pre_event", node);
            }
            if (node.left != null) {
                this.raise_events(node.left, parserEventHandler);
                if (node.right != null) {
                    this.raise_events(node.right, parserEventHandler);
                }
            }
            if (node.fire_event) {
                parserEventHandler.handleEvent(node_rule_name + "_post_event", node);
            }
        }
    }

    protected void fill_tree(TreeNode node, DPNode dp_node) {
        long bottom_rule = 0L;
        long top_rule = 0L;
        if (dp_node.left != null) {
            bottom_rule = this.compute_rule_key(dp_node.rule_index_1, dp_node.rule_index_2);
            top_rule = node.rule_index;
        } else {
            top_rule = dp_node.rule_index_2;
            bottom_rule = this.originalTtoNT.get(Character.valueOf((char)dp_node.rule_index_1));
        }
        long subst_key = bottom_rule + (top_rule << 16);
        if (bottom_rule != top_rule && this.substitution.containsKey(subst_key)) {
            for (long rule_index : this.substitution.get(subst_key)) {
                node = node.left = new TreeNode(rule_index, this.NTtoRule.containsKey(rule_index));
            }
        }
        if (dp_node.left != null) {
            node.left = new TreeNode(dp_node.rule_index_1, this.NTtoRule.containsKey(dp_node.rule_index_1));
            node.right = new TreeNode(dp_node.rule_index_2, this.NTtoRule.containsKey(dp_node.rule_index_2));
            this.fill_tree(node.left, dp_node.left);
            this.fill_tree(node.right, dp_node.right);
        } else {
            node.terminal = (char)dp_node.rule_index_1;
        }
    }

    public T parse(String textToParse, BaseParserEventHandler<T> parserEventHandler) {
        return this.parse(textToParse, parserEventHandler, true);
    }

    public T parse(String textToParse, BaseParserEventHandler<T> parserEventHandler, boolean throwError) {
        String old_text = textToParse;
        if (this.usedEof) {
            textToParse = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)textToParse);
        }
        parserEventHandler.content = null;
        for (Map.Entry<String, Long> rule_name : this.ruleToNT.entrySet()) {
            parserEventHandler.ruleNames.add(rule_name.getKey());
        }
        parserEventHandler.sanityCheck(this);
        try {
            Optional<ParsingErrors> parsingErrors = this.parse_regular((String)textToParse, parserEventHandler);
            if (parsingErrors.isPresent() && !parsingErrors.get().wordInGrammar) {
                if (throwError) {
                    throw new LipidParsingException("Lipid '" + old_text + "' can not be parsed by grammar '" + this.grammarName + "'");
                }
                parserEventHandler.errorMessage = parsingErrors.get().errorMessage;
            }
        }
        catch (RuntimeException lpe) {
            if (throwError) {
                throw new LipidParsingException("Lipid '" + old_text + "' can not be parsed by grammar '" + this.grammarName + "': ", lpe);
            }
            parserEventHandler.errorMessage = lpe.getLocalizedMessage();
        }
        return parserEventHandler.content;
    }

    protected Optional<ParsingErrors> parse_regular(String text_to_parse, BaseParserEventHandler<T> parserEventHandler) {
        int i;
        boolean wordInGrammar = false;
        int n = text_to_parse.length();
        ArrayList DP = new ArrayList();
        Bitfield[] Ks = new Bitfield[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ArrayList list = new ArrayList();
            for (int j = 0; j < n - i2; ++j) {
                list.add(new HashMap());
            }
            DP.add(list);
            Ks[i2] = new Bitfield(n);
        }
        boolean requirement_fulfilled = true;
        for (i = 0; i < n; ++i) {
            char c = text_to_parse.charAt(i);
            if (!this.TtoNT.containsKey(Character.valueOf(c))) {
                requirement_fulfilled = false;
                break;
            }
            for (long T_rule_index : this.TtoNT.get(Character.valueOf(c))) {
                DPNode dp_node = new DPNode(c, T_rule_index, null, null);
                ((HashMap)((ArrayList)DP.get(i)).get(0)).put(T_rule_index, dp_node);
            }
            Ks[i].add(0);
        }
        if (requirement_fulfilled) {
            for (i = 1; i < n; ++i) {
                int im1 = i - 1;
                for (int j = 0; j < n - i; ++j) {
                    ArrayList DPj = (ArrayList)DP.get(j);
                    HashMap DPji = (HashMap)DPj.get(i);
                    int jp1 = j + 1;
                    Ks[j].resetIterator();
                    while (Ks[j].hasNext()) {
                        int im1mk;
                        int k = Ks[j].next();
                        int jpok = jp1 + k;
                        if (!Ks[jpok].find(im1mk = im1 - k)) continue;
                        for (Map.Entry index_pair_1 : ((HashMap)((ArrayList)DP.get(j)).get(k)).entrySet()) {
                            Bitfield b = this.rightPair.get((int)((Long)index_pair_1.getKey()).longValue());
                            for (Map.Entry index_pair_2 : ((HashMap)((ArrayList)DP.get(jpok)).get(im1mk)).entrySet()) {
                                if (!b.find((int)((Long)index_pair_2.getKey()).longValue())) continue;
                                long key = this.compute_rule_key((Long)index_pair_1.getKey(), (Long)index_pair_2.getKey());
                                DPNode content = new DPNode((Long)index_pair_1.getKey(), (Long)index_pair_2.getKey(), (DPNode)index_pair_1.getValue(), (DPNode)index_pair_2.getValue());
                                for (long rule_index : this.NTtoNT.get(key)) {
                                    if (DPji.containsKey(rule_index)) continue;
                                    DPji.put(rule_index, content);
                                }
                            }
                        }
                    }
                    if (DPji.size() <= 0) continue;
                    Ks[j].add(i);
                }
            }
            for (i = n - 1; i > 0; --i) {
                if (!((HashMap)((ArrayList)DP.get(0)).get(i)).containsKey(2L)) continue;
                wordInGrammar = true;
                TreeNode parse_tree = new TreeNode(2L, this.NTtoRule.containsKey(2L));
                this.fill_tree(parse_tree, (DPNode)((HashMap)((ArrayList)DP.get(0)).get(i)).get(2L));
                this.raise_events(parse_tree, parserEventHandler);
                break;
            }
            if (!wordInGrammar) {
                for (i = n - 1; i > 0; --i) {
                    if (((HashMap)((ArrayList)DP.get(0)).get(i)).size() <= 0) continue;
                    long first_rule = (Long)((HashMap)((ArrayList)DP.get(0)).get(i)).keySet().iterator().next();
                    TreeNode parse_tree = new TreeNode(first_rule, this.NTtoRule.containsKey(first_rule));
                    this.fill_tree(parse_tree, (DPNode)((HashMap)((ArrayList)DP.get(0)).get(i)).get(first_rule));
                    return Optional.of(new ParsingErrors(wordInGrammar, parse_tree.getText()));
                }
            }
        }
        return Optional.empty();
    }

    static enum Context {
        NoContext,
        InLineComment,
        InLongComment,
        InQuote;

    }

    static enum MatchWords {
        NoMatch,
        LineCommentStart,
        LineCommentEnd,
        LongCommentStart,
        LongCommentEnd,
        Quote;

    }

    protected final class DPNode {
        public long rule_index_1;
        public long rule_index_2;
        public DPNode left = null;
        public DPNode right = null;

        public DPNode(long _rule1, long _rule2, DPNode _left, DPNode _right) {
            this.rule_index_1 = _rule1;
            this.rule_index_2 = _rule2;
            this.left = _left;
            this.right = _right;
        }
    }

    protected class ParsingErrors {
        final boolean wordInGrammar;
        final String errorMessage;

        ParsingErrors(boolean wordInGrammar, String errorMessage) {
            this.wordInGrammar = wordInGrammar;
            this.errorMessage = errorMessage;
        }
    }
}

