/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidSpecies;

public class LipidMolecularSpecies
extends LipidSpecies {
    public LipidMolecularSpecies(Headgroup _headgroup, KnownFunctionalGroups knownFunctionalGroups) {
        this(_headgroup, Collections.emptyList(), knownFunctionalGroups);
    }

    public LipidMolecularSpecies(Headgroup _headgroup, Collection<FattyAcid> _fa, KnownFunctionalGroups knownFunctionalGroups) {
        super(_headgroup, _fa, knownFunctionalGroups);
        this.info.setLevel(LipidLevel.MOLECULAR_SPECIES);
        for (FattyAcid fatty_acid : _fa) {
            if (this.fa.containsKey(fatty_acid.getName())) {
                throw new ConstraintViolationException("FA names must be unique! FA with name " + fatty_acid.getName() + " was already added!");
            }
            this.fa.put(fatty_acid.getName(), fatty_acid);
            this.faList.add(fatty_acid);
        }
        for (int i = _fa.size(); i < this.info.totalFa; ++i) {
            FattyAcid fatty_acid;
            fatty_acid = new FattyAcid("FA" + Integer.toString(i + 1), knownFunctionalGroups);
            fatty_acid.position = -1;
            this.info.add(fatty_acid);
            this.fa.put(fatty_acid.getName(), fatty_acid);
            this.faList.add(fatty_acid);
        }
    }

    public String buildLipidSubspeciesName() {
        return this.buildLipidSubspeciesName(LipidLevel.NO_LEVEL);
    }

    public String buildLipidSubspeciesName(LipidLevel level) {
        if (level == LipidLevel.NO_LEVEL) {
            level = LipidLevel.MOLECULAR_SPECIES;
        }
        String fa_separator = level != LipidLevel.MOLECULAR_SPECIES || this.headGroup.getLipidCategory() == LipidCategory.SP ? "/" : "_";
        StringBuilder lipid_name = new StringBuilder();
        lipid_name.append(this.headGroup.getLipidString(level));
        String fa_headgroup_separator = this.headGroup.getLipidCategory() != LipidCategory.ST ? " " : "/";
        switch (level) {
            case COMPLETE_STRUCTURE: 
            case FULL_STRUCTURE: 
            case STRUCTURE_DEFINED: 
            case SN_POSITION: {
                if (this.faList.size() <= 0) break;
                lipid_name.append(fa_headgroup_separator);
                int i = 0;
                for (FattyAcid fatty_acid : this.faList) {
                    if (i++ > 0) {
                        lipid_name.append(fa_separator);
                    }
                    lipid_name.append(fatty_acid.toString(level));
                }
                break;
            }
            default: {
                boolean go_on = false;
                for (FattyAcid fatty_acid : this.faList) {
                    if (fatty_acid.numCarbon <= 0) continue;
                    go_on = true;
                    break;
                }
                if (!go_on) break;
                lipid_name.append(fa_headgroup_separator);
                int i = 0;
                for (FattyAcid fatty_acid : this.faList) {
                    if (fatty_acid.numCarbon <= 0) continue;
                    if (i++ > 0) {
                        lipid_name.append(fa_separator);
                    }
                    lipid_name.append(fatty_acid.toString(level));
                }
            }
        }
        return lipid_name.toString();
    }

    @Override
    public LipidLevel getLipidLevel() {
        return LipidLevel.MOLECULAR_SPECIES;
    }

    @Override
    @JsonIgnore
    public ElementTable getElements() {
        ElementTable elements = this.headGroup.getElements();
        this.faList.forEach(fatty_acid -> elements.add(fatty_acid.computeAndCopyElements()));
        return elements;
    }

    @Override
    public String getLipidString() {
        return this.getLipidString(LipidLevel.NO_LEVEL);
    }

    @Override
    public String getLipidString(LipidLevel level) {
        switch (level) {
            case NO_LEVEL: 
            case MOLECULAR_SPECIES: {
                return this.buildLipidSubspeciesName(LipidLevel.MOLECULAR_SPECIES);
            }
            case CATEGORY: 
            case CLASS: 
            case SPECIES: {
                return super.getLipidString(level);
            }
        }
        throw new IllegalArgumentException("LipidMolecularSpecies does not know how to create a lipid string for level " + level.toString());
    }
}

