/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.Map;
import java.util.TreeMap;
import org.lifstools.jgoslin.domain.ConstraintViolationException;

public final class DoubleBonds {
    private int numDoubleBonds;
    protected final Map<Integer, String> doubleBondPositions;

    public DoubleBonds() {
        this.numDoubleBonds = 0;
        this.doubleBondPositions = new TreeMap<Integer, String>();
    }

    public DoubleBonds(int num) {
        this.numDoubleBonds = num;
        this.doubleBondPositions = new TreeMap<Integer, String>();
    }

    public DoubleBonds(TreeMap<Integer, String> db) {
        this.numDoubleBonds = db.size();
        this.doubleBondPositions = db;
    }

    public DoubleBonds copy() {
        DoubleBonds db = new DoubleBonds(this.numDoubleBonds);
        this.doubleBondPositions.entrySet().forEach(kv -> db.doubleBondPositions.put((Integer)kv.getKey(), (String)kv.getValue()));
        return db;
    }

    public int getNumDoubleBonds() {
        if (this.doubleBondPositions.size() > 0 && this.doubleBondPositions.size() != this.numDoubleBonds) {
            throw new ConstraintViolationException("Number of double bonds '" + Integer.toString(this.numDoubleBonds) + "' does not match to number of double bond positions '" + Integer.toString(this.doubleBondPositions.size()) + "'");
        }
        return this.numDoubleBonds;
    }

    public void setNumDoubleBonds(int numDoubleBonds) {
        this.numDoubleBonds = numDoubleBonds;
    }

    public Map<Integer, String> getDoubleBondPositions() {
        return this.doubleBondPositions;
    }
}

