/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.Cycle;
import org.lifstools.jgoslin.domain.Dictionary;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.domain.UnsupportedLipidException;
import org.lifstools.jgoslin.parser.LipidBaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class HmdbParserEventHandler
extends LipidBaseParserEventHandler {
    private int dbPositions;
    private String dbCistrans;
    private Dictionary furan = null;

    public HmdbParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        super(knownFunctionalGroups);
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("lipid_pre_event", this::resetParser), Map.entry("lipid_post_event", this::buildLipid), Map.entry("adduct_info_pre_event", this::newAdduct), Map.entry("adduct_pre_event", this::addAdduct), Map.entry("charge_pre_event", this::addCharge), Map.entry("charge_sign_pre_event", this::addChargeSign), Map.entry("fa_hg_pre_event", this::setHeadGroupName), Map.entry("gl_hg_pre_event", this::setHeadGroupName), Map.entry("gl_molecular_hg_pre_event", this::setHeadGroupName), Map.entry("mediator_pre_event", this::mediatorEvent), Map.entry("gl_mono_hg_pre_event", this::setHeadGroupName), Map.entry("pl_hg_pre_event", this::setHeadGroupName), Map.entry("pl_three_hg_pre_event", this::setHeadGroupName), Map.entry("pl_four_hg_pre_event", this::setHeadGroupName), Map.entry("sl_hg_pre_event", this::setHeadGroupName), Map.entry("st_species_hg_pre_event", this::setHeadGroupName), Map.entry("st_sub1_hg_pre_event", this::setHeadGroupName), Map.entry("st_sub2_hg_pre_event", this::setHeadGroupName), Map.entry("ganglioside_names_pre_event", this::setHeadGroupName), Map.entry("fa_species_pre_event", this::setSpeciesLevel), Map.entry("gl_molecular_pre_event", this::setMolecularLevel), Map.entry("unsorted_fa_separator_pre_event", this::setMolecularLevel), Map.entry("fa2_unsorted_pre_event", this::setMolecularLevel), Map.entry("fa3_unsorted_pre_event", this::setMolecularLevel), Map.entry("fa4_unsorted_pre_event", this::setMolecularLevel), Map.entry("db_single_position_pre_event", this::setIsomericLevel), Map.entry("db_single_position_post_event", this::addDbPosition), Map.entry("db_position_number_pre_event", this::addDbPositionNumber), Map.entry("cistrans_pre_event", this::addCistrans), Map.entry("lcb_pre_event", this::newLcb), Map.entry("lcb_post_event", this::cleanLcb), Map.entry("fa_pre_event", this::newFa), Map.entry("fa_post_event", this::appendFa), Map.entry("ether_pre_event", this::addEther), Map.entry("hydroxyl_pre_event", this::addHydroxyl), Map.entry("db_count_pre_event", this::addDoubleBonds), Map.entry("carbon_pre_event", this::addCarbon), Map.entry("fa_lcb_suffix_type_pre_event", this::addOneHydroxyl), Map.entry("interlink_fa_pre_event", this::interlinkFa), Map.entry("lipid_suffix_pre_event", this::lipidSuffix), Map.entry("methyl_pre_event", this::addMethyl), Map.entry("furan_fa_pre_event", this::furanFa), Map.entry("furan_fa_post_event", this::furanFaPost), Map.entry("furan_fa_mono_pre_event", this::furanFaMono), Map.entry("furan_fa_di_pre_event", this::furanFaDi), Map.entry("furan_first_number_pre_event", this::furanFaFirstNumber), Map.entry("furan_second_number_pre_event", this::furanFaSecondNumber));
        }
        catch (Exception e) {
            throw new LipidParsingException("Cannot initialize LipidMapsParserEventHandler.");
        }
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = null;
        this.level = LipidLevel.FULL_STRUCTURE;
        this.headGroup = "";
        this.lcb = null;
        this.adduct = null;
        this.faList.clear();
        this.currentFa = null;
        this.useHeadGroup = false;
        this.dbPositions = 0;
        this.dbCistrans = "";
        this.furan = new Dictionary();
    }

    private void setIsomericLevel(TreeNode node) {
        this.dbPositions = 0;
        this.dbCistrans = "";
    }

    private void addDbPosition(TreeNode node) {
        if (this.currentFa != null) {
            this.currentFa.getDoubleBonds().getDoubleBondPositions().put(this.dbPositions, this.dbCistrans);
            if (!this.dbCistrans.equals("E") && !this.dbCistrans.equals("Z")) {
                this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
            }
        }
    }

    private void addDbPositionNumber(TreeNode node) {
        this.dbPositions = node.getInt();
    }

    private void addCistrans(TreeNode node) {
        this.dbCistrans = node.getText();
    }

    private void setHeadGroupName(TreeNode node) {
        this.headGroup = node.getText();
    }

    private void setSpeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.SPECIES);
    }

    private void setMolecularLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
    }

    private void mediatorEvent(TreeNode node) {
        this.useHeadGroup = true;
        this.headGroup = node.getText();
    }

    private void newFa(TreeNode node) {
        this.currentFa = new FattyAcid("FA", this.knownFunctionalGroups);
    }

    private void newLcb(TreeNode node) {
        this.lcb = new FattyAcid("LCB", this.knownFunctionalGroups);
        this.lcb.setType(LipidFaBondType.LCB_REGULAR);
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        this.currentFa = this.lcb;
    }

    private void cleanLcb(TreeNode node) {
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        this.currentFa = null;
    }

    private void appendFa(TreeNode node) {
        if (this.currentFa.getDoubleBonds().getNumDoubleBonds() < 0) {
            throw new LipidException("Double bond count does not match with number of double bond positions");
        }
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        this.faList.add(this.currentFa);
        this.currentFa = null;
    }

    private void buildLipid(TreeNode node) {
        if (this.lcb != null) {
            this.faList.add(0, this.lcb);
        }
        Headgroup headgroup = this.prepareHeadgroupAndChecks();
        LipidAdduct lipid = new LipidAdduct(this.assembleLipid(headgroup), this.adduct);
        this.content = lipid;
    }

    private void addEther(TreeNode node) {
        String ether = node.getText();
        if (ether.equals("O-") || ether.equals("o-")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMANYL);
        } else if (ether.equals("P-")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMENYL);
        } else {
            throw new UnsupportedLipidException("Fatty acyl chain of type '" + ether + "' is currently not supported");
        }
    }

    private void addHydroxyl(TreeNode node) {
        String old_hydroxyl = node.getText();
        int num_h = 0;
        if (old_hydroxyl.equals("d")) {
            num_h = 2;
        } else if (old_hydroxyl.equals("t")) {
            num_h = 3;
        }
        if (this.spRegularLcb()) {
            --num_h;
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
        functional_group.setCount(num_h);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
            this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
    }

    private void addMethyl(TreeNode node) {
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("Me");
        functional_group.setPosition(this.currentFa.getNumCarbon() - (node.getText().equals("i-") ? 1 : 2));
        this.currentFa.setNumCarbon(this.currentFa.getNumCarbon() - 1);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("Me")) {
            this.currentFa.getFunctionalGroupsInternal().put("Me", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("Me").add(functional_group);
    }

    private void addOneHydroxyl(TreeNode node) {
        if (this.currentFa.getFunctionalGroupsInternal().containsKey("OH") && this.currentFa.getFunctionalGroupsInternal().get("OH").get(0).getPosition() == -1) {
            this.currentFa.getFunctionalGroupsInternal().get("OH").get(0).setCount(this.currentFa.getFunctionalGroupsInternal().get("OH").get(0).getCount() + 1);
        } else {
            FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
            if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
                this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
            }
            this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
        }
    }

    private void addDoubleBonds(TreeNode node) {
        this.currentFa.getDoubleBonds().setNumDoubleBonds(node.getInt());
    }

    private void addCarbon(TreeNode node) {
        this.currentFa.setNumCarbon(this.currentFa.getNumCarbon() + node.getInt());
    }

    private void furanFa(TreeNode node) {
        this.furan = new Dictionary();
    }

    private void furanFaPost(TreeNode node) {
        int l = 4 + (Integer)this.furan.get("len_first") + (Integer)this.furan.get("len_second");
        this.currentFa.setNumCarbon(l);
        int start = 1 + (Integer)this.furan.get("len_first");
        int end = 3 + start;
        DoubleBonds cyclo_db = new DoubleBonds(2);
        cyclo_db.getDoubleBondPositions().put(start, "E");
        cyclo_db.getDoubleBondPositions().put(2 + start, "E");
        HashMap<String, ArrayList<FunctionalGroup>> cyclo_fg = new HashMap<String, ArrayList<FunctionalGroup>>();
        cyclo_fg.put("Me", new ArrayList());
        if (((String)this.furan.get("type")).equals("m")) {
            fg = this.knownFunctionalGroups.get("Me");
            fg.setPosition(1 + start);
            ((ArrayList)cyclo_fg.get("Me")).add(fg);
        } else if (((String)this.furan.get("type")).equals("d")) {
            fg = this.knownFunctionalGroups.get("Me");
            fg.setPosition(1 + start);
            ((ArrayList)cyclo_fg.get("Me")).add(fg);
            fg = this.knownFunctionalGroups.get("Me");
            fg.setPosition(2 + start);
            cyclo_fg.get("Me").add(fg);
        }
        ArrayList<Element> bridge_chain = new ArrayList<Element>();
        bridge_chain.add(Element.O);
        Cycle cycle = new Cycle(end - start + 1 + bridge_chain.size(), start, end, cyclo_db, cyclo_fg, bridge_chain, this.knownFunctionalGroups);
        this.currentFa.getFunctionalGroupsInternal().put("cy", new ArrayList());
        this.currentFa.getFunctionalGroupsInternal().get("cy").add(cycle);
    }

    private void furanFaMono(TreeNode node) {
        this.furan.put("type", "m");
    }

    private void furanFaDi(TreeNode node) {
        this.furan.put("type", "d");
    }

    private void furanFaFirstNumber(TreeNode node) {
        this.furan.put("len_first", node.getInt());
    }

    private void furanFaSecondNumber(TreeNode node) {
        this.furan.put("len_second", node.getInt());
    }

    private void interlinkFa(TreeNode node) {
        throw new UnsupportedLipidException("Interconnected fatty acyl chains are currently not supported");
    }

    private void lipidSuffix(TreeNode node) {
    }

    private void newAdduct(TreeNode node) {
        this.adduct = new Adduct("", "");
    }

    private void addAdduct(TreeNode node) {
        this.adduct.setAdductString(node.getText());
    }

    private void addCharge(TreeNode node) {
        this.adduct.setCharge(Integer.valueOf(node.getText()));
    }

    private void addChargeSign(TreeNode node) {
        String sign = node.getText();
        if (sign.equals("+")) {
            this.adduct.setChargeSign(1);
        } else if (sign.equals("-")) {
            this.adduct.setChargeSign(-1);
        }
    }
}

