/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.lifstools.jgoslin.domain.AcylAlkylGroup;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.CarbonChain;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Cycle;
import org.lifstools.jgoslin.domain.Dictionary;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.GenericList;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.parser.LipidBaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class ShorthandParserEventHandler
extends LipidBaseParserEventHandler {
    private ArrayDeque<FunctionalGroup> currentFas = new ArrayDeque();
    private Dictionary tmp = new Dictionary();
    private boolean acerSpecies = false;
    private static final Set<String> SPECIAL_TYPES = Set.of("acyl", "alkyl", "decorator_acyl", "decorator_alkyl", "cc");
    private boolean containsStereoInformation = false;

    public ShorthandParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        super(knownFunctionalGroups);
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("lipid_pre_event", this::resetParser), Map.entry("lipid_post_event", this::buildLipid), Map.entry("sl_pre_event", this::preSphingolipid), Map.entry("sl_post_event", this::postSphingolipid), Map.entry("sl_hydroxyl_pre_event", this::setHydroxyl), Map.entry("adduct_info_pre_event", this::newAdduct), Map.entry("adduct_pre_event", this::addAdduct), Map.entry("charge_pre_event", this::addCharge), Map.entry("charge_sign_pre_event", this::addChargeSign), Map.entry("med_species_pre_event", this::setSpeciesLevel), Map.entry("gl_species_pre_event", this::setSpeciesLevel), Map.entry("gl_molecular_species_pre_event", this::setMolecularLevel), Map.entry("pl_species_pre_event", this::setSpeciesLevel), Map.entry("pl_molecular_species_pre_event", this::setMolecularLevel), Map.entry("sl_species_pre_event", this::setSpeciesLevel), Map.entry("pl_single_pre_event", this::setMolecularLevel), Map.entry("unsorted_fa_separator_pre_event", this::setMolecularLevel), Map.entry("ether_num_pre_event", this::setEtherNum), Map.entry("stereo_type_fa_pre_event", this::setFattyAcylStereo), Map.entry("med_hg_single_pre_event", this::setHeadgroupName), Map.entry("med_hg_double_pre_event", this::setHeadgroupName), Map.entry("med_hg_triple_pre_event", this::setHeadgroupName), Map.entry("gl_hg_single_pre_event", this::setHeadgroupName), Map.entry("gl_hg_double_pre_event", this::setHeadgroupName), Map.entry("gl_hg_true_double_pre_event", this::setHeadgroupName), Map.entry("gl_hg_triple_pre_event", this::setHeadgroupName), Map.entry("pl_hg_single_pre_event", this::setHeadgroupName), Map.entry("pl_hg_double_pre_event", this::setHeadgroupName), Map.entry("pl_hg_quadro_pre_event", this::setHeadgroupName), Map.entry("sl_hg_single_pre_event", this::setHeadgroupName), Map.entry("pl_hg_double_fa_hg_pre_event", this::setHeadgroupName), Map.entry("sl_hg_double_name_pre_event", this::setHeadgroupName), Map.entry("st_hg_pre_event", this::setHeadgroupName), Map.entry("st_hg_ester_pre_event", this::setHeadgroupName), Map.entry("hg_pip_pure_m_pre_event", this::setHeadgroupName), Map.entry("hg_pip_pure_d_pre_event", this::setHeadgroupName), Map.entry("hg_pip_pure_t_pre_event", this::setHeadgroupName), Map.entry("hg_PE_PS_pre_event", this::setHeadgroupName), Map.entry("carbohydrate_pre_event", this::setCarbohydrate), Map.entry("carbohydrate_structural_pre_event", this::setCarbohydrateStructural), Map.entry("carbohydrate_isomeric_pre_event", this::setCarbohydrateIsomeric), Map.entry("lcb_post_event", this::setLcb), Map.entry("fatty_acyl_chain_pre_event", this::newFattyAcylChain), Map.entry("fatty_acyl_chain_post_event", this::addFattyAcylChain), Map.entry("carbon_pre_event", this::setCarbon), Map.entry("db_count_pre_event", this::setDoubleBondCount), Map.entry("db_position_number_pre_event", this::setDoubleBondPosition), Map.entry("db_single_position_pre_event", this::setDoubleBondInformation), Map.entry("db_single_position_post_event", this::addDoubleBondInformation), Map.entry("cistrans_pre_event", this::setCisTrans), Map.entry("ether_type_pre_event", this::setEtherType), Map.entry("func_group_data_pre_event", this::setFunctionalGroup), Map.entry("func_group_data_post_event", this::addFunctionalGroup), Map.entry("func_group_pos_number_pre_event", this::setFunctionalGroupPosition), Map.entry("func_group_name_pre_event", this::setFunctionalGroupName), Map.entry("func_group_count_pre_event", this::setFunctionalGroupCount), Map.entry("stereo_type_fg_pre_event", this::setFunctionalGroupStereo), Map.entry("molecular_func_group_name_pre_event", this::setSnPositionFuncGroup), Map.entry("func_group_cycle_pre_event", this::setCycle), Map.entry("func_group_cycle_post_event", this::addCycle), Map.entry("cycle_start_pre_event", this::setCycleStart), Map.entry("cycle_end_pre_event", this::setCycleEnd), Map.entry("cycle_number_pre_event", this::setCycleNumber), Map.entry("cycle_db_cnt_pre_event", this::setCycleDbCount), Map.entry("cycle_db_positions_pre_event", this::setCycleDbPositions), Map.entry("cycle_db_positions_post_event", this::checkCycleDbPositions), Map.entry("cycle_db_position_number_pre_event", this::setCycleDbPosition), Map.entry("cycle_db_position_cis_trans_pre_event", this::setCycleDbPositionCistrans), Map.entry("cylce_element_pre_event", this::addCycleElement), Map.entry("fatty_acyl_linkage_pre_event", this::setAcylLinkage), Map.entry("fatty_acyl_linkage_post_event", this::addAcylLinkage), Map.entry("fatty_alkyl_linkage_pre_event", this::setAlkylLinkage), Map.entry("fatty_alkyl_linkage_post_event", this::addAlkylLinkage), Map.entry("fatty_linkage_number_pre_event", this::setFattyLinkageNumber), Map.entry("fatty_acyl_linkage_sign_pre_event", this::setLinkageType), Map.entry("hydrocarbon_chain_pre_event", this::setHydrocarbonChain), Map.entry("hydrocarbon_chain_post_event", this::addHydrocarbonChain), Map.entry("hydrocarbon_number_pre_event", this::setFattyLinkageNumber), Map.entry("ring_stereo_pre_event", this::setRingStereo), Map.entry("pl_hg_fa_pre_event", this::setHgAcyl), Map.entry("pl_hg_fa_post_event", this::addHgAcyl), Map.entry("pl_hg_alk_pre_event", this::setHgAlkyl), Map.entry("pl_hg_alk_post_event", this::addHgAlkyl), Map.entry("pl_hg_species_pre_event", this::addPlSpeciesData), Map.entry("hg_pip_m_pre_event", this::suffixDecoratorMolecular), Map.entry("hg_pip_d_pre_event", this::suffixDecoratorMolecular), Map.entry("hg_pip_t_pre_event", this::suffixDecoratorMolecular), Map.entry("hg_PE_PS_type_pre_event", this::suffixDecoratorSpecies), Map.entry("acer_hg_post_event", this::setAcer), Map.entry("acer_species_post_event", this::setAcerSpecies), Map.entry("sterol_definition_post_event", this::setSterolDefinition));
        }
        catch (Exception e) {
            throw new LipidParsingException("Cannot initialize ShorthandParserEventHandler.");
        }
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = null;
        this.level = LipidLevel.FULL_STRUCTURE;
        this.adduct = null;
        this.headGroup = "";
        this.faList.clear();
        this.currentFas.clear();
        this.headgroupDecorators = new ArrayList();
        this.tmp = new Dictionary();
        this.acerSpecies = false;
        this.containsStereoInformation = false;
    }

    private String faI() {
        return "fa" + Integer.toString(this.currentFas.size());
    }

    private void buildLipid(TreeNode node) {
        int fa_it;
        if (this.acerSpecies) {
            ((FattyAcid)this.faList.get(0)).setNumCarbon(((FattyAcid)this.faList.get(0)).getNumCarbon() - 2);
        }
        Headgroup headgroup = this.prepareHeadgroupAndChecks();
        if (this.level == LipidLevel.FULL_STRUCTURE && this.containsStereoInformation) {
            this.level = LipidLevel.COMPLETE_STRUCTURE;
        }
        for (int it = fa_it = this.faList.size() > 0 && (((FattyAcid)this.faList.get(0)).getLipidFaBondType() == LipidFaBondType.LCB_EXCEPTION || ((FattyAcid)this.faList.get(0)).getLipidFaBondType() == LipidFaBondType.LCB_REGULAR) ? 1 : 0; it < this.faList.size(); ++it) {
            ((FattyAcid)this.faList.get(it)).setName(((FattyAcid)this.faList.get(it)).getName() + Integer.toString(it + 1));
        }
        LipidAdduct lipid = new LipidAdduct(this.assembleLipid(headgroup), this.adduct);
        if (this.tmp.containsKey("num_ethers")) {
            lipid.getLipid().getInfo().numEthers = (Integer)this.tmp.get("num_ethers");
        }
        this.content = lipid;
    }

    private void setSterolDefinition(TreeNode node) {
        this.headGroup = this.headGroup + " " + node.getText();
        this.faList.remove(0);
    }

    private void preSphingolipid(TreeNode node) {
        this.tmp.put("sl_hydroxyl", 0);
    }

    private void postSphingolipid(TreeNode node) {
        if ((Integer)this.tmp.get("sl_hydroxyl") == 0 && !this.headGroup.equals("Cer") && !this.headGroup.equals("SPB")) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
    }

    private void setHydroxyl(TreeNode node) {
        this.tmp.put("sl_hydroxyl", 1);
    }

    private void newAdduct(TreeNode node) {
        this.adduct = new Adduct("", "", 0, 0);
    }

    private void addAdduct(TreeNode node) {
        this.adduct.setAdductString(node.getText());
    }

    private void addCharge(TreeNode node) {
        this.adduct.setCharge(Integer.valueOf(node.getText()));
    }

    private void addChargeSign(TreeNode node) {
        String sign = node.getText();
        if (sign.equals("+")) {
            this.adduct.setChargeSign(1);
        } else {
            this.adduct.setChargeSign(-1);
        }
    }

    private void setSpeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.SPECIES);
    }

    private void setMolecularLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
    }

    private void setEtherNum(TreeNode node) {
        String ether;
        int num_ethers = 0;
        switch (ether = node.getText()) {
            case "d": {
                num_ethers = 2;
                break;
            }
            case "t": {
                num_ethers = 3;
                break;
            }
            case "e": {
                num_ethers = 4;
                break;
            }
        }
        this.tmp.put("num_ethers", num_ethers);
    }

    private void setHeadgroupName(TreeNode node) {
        if (this.headGroup.length() == 0) {
            this.headGroup = node.getText();
        }
    }

    private void setCarbohydrate(TreeNode node) {
        String carbohydrate = node.getText();
        FunctionalGroup functional_group = null;
        try {
            functional_group = this.knownFunctionalGroups.get(carbohydrate);
        }
        catch (Exception e) {
            throw new LipidParsingException("Carbohydrate '" + carbohydrate + "' unknown");
        }
        functional_group.getElements().put(Element.O, (Integer)functional_group.getElements().get((Object)Element.O) - 1);
        if (this.tmp.containsKey("func_group_head") && (Integer)this.tmp.get("func_group_head") == 1) {
            this.headgroupDecorators.add((HeadgroupDecorator)functional_group);
        } else {
            if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey(carbohydrate)) {
                this.currentFas.peekLast().getFunctionalGroupsInternal().put(carbohydrate, new ArrayList());
            }
            this.currentFas.peekLast().getFunctionalGroupsInternal().get(carbohydrate).add(functional_group);
        }
    }

    private void setFattyAcylStereo(TreeNode node) {
        this.currentFas.getLast().setStereochemistry(node.getText());
        this.containsStereoInformation = true;
    }

    private void setCarbohydrateStructural(TreeNode node) {
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        this.tmp.put("func_group_head", 1);
    }

    private void setCarbohydrateIsomeric(TreeNode node) {
        this.tmp.put("func_group_head", 1);
    }

    private void setLcb(TreeNode node) {
        FattyAcid fa = (FattyAcid)this.faList.get(this.faList.size() - 1);
        fa.setName("LCB");
        fa.setType(LipidFaBondType.LCB_REGULAR);
    }

    private void newFattyAcylChain(TreeNode node) {
        this.currentFas.add(new FattyAcid("FA", this.knownFunctionalGroups));
        this.tmp.put(this.faI(), new Dictionary());
    }

    private void addFattyAcylChain(TreeNode node) {
        String fg_name;
        String fg_i = "fa" + Integer.toString(this.currentFas.size() - 2);
        String special_type = "";
        if (this.currentFas.size() >= 2 && this.tmp.containsKey(fg_i) && ((Dictionary)this.tmp.get(fg_i)).containsKey("fg_name") && SPECIAL_TYPES.contains(fg_name = (String)((Dictionary)this.tmp.get(fg_i)).get("fg_name"))) {
            special_type = fg_name;
        }
        String fa_i = this.faI();
        if (this.currentFas.peekLast().getDoubleBonds().getNumDoubleBonds() != ((Integer)((Dictionary)this.tmp.get(fa_i)).get("db_count")).intValue()) {
            throw new LipidException("Double bond count does not match with number of double bond positions");
        }
        if (this.currentFas.peekLast().getDoubleBonds().getNumDoubleBonds() > 0 && this.currentFas.peekLast().getDoubleBonds().getDoubleBondPositions().isEmpty()) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        this.tmp.remove(fa_i);
        FattyAcid fa = (FattyAcid)this.currentFas.pollLast();
        if (special_type.length() > 0) {
            fa.setName(special_type);
            if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey(special_type)) {
                this.currentFas.peekLast().getFunctionalGroupsInternal().put(special_type, new ArrayList());
            }
            this.currentFas.peekLast().getFunctionalGroupsInternal().get(special_type).add(fa);
        } else {
            this.faList.add(fa);
        }
    }

    private void setCarbon(TreeNode node) {
        ((FattyAcid)this.currentFas.peekLast()).setNumCarbon(Integer.valueOf(node.getText()));
    }

    private void setDoubleBondCount(TreeNode node) {
        int db_cnt = Integer.valueOf(node.getText());
        ((Dictionary)this.tmp.get(this.faI())).put("db_count", db_cnt);
        ((FattyAcid)this.currentFas.peekLast()).getDoubleBonds().setNumDoubleBonds(db_cnt);
    }

    private void setDoubleBondPosition(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("db_position", Integer.valueOf(node.getText()));
    }

    private void setDoubleBondInformation(TreeNode node) {
        String fa_i = this.faI();
        ((Dictionary)this.tmp.get(fa_i)).put("db_position", 0);
        ((Dictionary)this.tmp.get(fa_i)).put("db_cistrans", "");
    }

    private void addDoubleBondInformation(TreeNode node) {
        String fa_i = this.faI();
        Dictionary d = (Dictionary)this.tmp.get(fa_i);
        int pos = (Integer)d.get("db_position");
        String cistrans = (String)d.get("db_cistrans");
        if (cistrans.equals("")) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        d.remove("db_position");
        d.remove("db_cistrans");
        this.currentFas.peekLast().getDoubleBonds().getDoubleBondPositions().put(pos, cistrans);
    }

    private void setCisTrans(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("db_cistrans", node.getText());
    }

    private void setEtherType(TreeNode node) {
        String ether_type = node.getText();
        if (ether_type.equals("O-")) {
            ((FattyAcid)this.currentFas.peekLast()).setLipidFaBondType(LipidFaBondType.ETHER_PLASMANYL);
        } else if (ether_type.equals("P-")) {
            ((FattyAcid)this.currentFas.peekLast()).setLipidFaBondType(LipidFaBondType.ETHER_PLASMENYL);
        }
    }

    private void setFunctionalGroup(TreeNode node) {
        String fa_i = this.faI();
        Dictionary gd = (Dictionary)this.tmp.get(fa_i);
        gd.put("fg_pos", -1);
        gd.put("fg_name", "0");
        gd.put("fg_cnt", 1);
        gd.put("fg_stereo", "");
        gd.put("fg_ring_stereo", "");
    }

    private void addFunctionalGroup(TreeNode node) {
        Dictionary gd = (Dictionary)this.tmp.get(this.faI());
        String fg_name = (String)gd.get("fg_name");
        if (SPECIAL_TYPES.contains(fg_name) || fg_name.equals("cy")) {
            return;
        }
        int fg_pos = (Integer)gd.get("fg_pos");
        int fg_cnt = (Integer)gd.get("fg_cnt");
        String fg_stereo = (String)gd.get("fg_stereo");
        String fg_ring_stereo = (String)gd.get("fg_ring_stereo");
        if (fg_pos == -1) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        FunctionalGroup functional_group = null;
        try {
            functional_group = this.knownFunctionalGroups.get(fg_name);
        }
        catch (Exception e) {
            throw new LipidParsingException("'" + fg_name + "' unknown");
        }
        functional_group.setPosition(fg_pos);
        functional_group.setCount(fg_cnt);
        functional_group.setStereochemistry(fg_stereo);
        functional_group.setRingStereo(fg_ring_stereo);
        gd.remove("fg_pos");
        gd.remove("fg_name");
        gd.remove("fg_cnt");
        gd.remove("fg_stereo");
        if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey(fg_name)) {
            this.currentFas.peekLast().getFunctionalGroupsInternal().put(fg_name, new ArrayList());
        }
        this.currentFas.peekLast().getFunctionalGroupsInternal().get(fg_name).add(functional_group);
    }

    private void setFunctionalGroupPosition(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_pos", Integer.valueOf(node.getText()));
    }

    private void setFunctionalGroupName(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", node.getText());
    }

    private void setFunctionalGroupCount(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_cnt", Integer.valueOf(node.getText()));
    }

    private void setFunctionalGroupStereo(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_stereo", node.getText());
        this.containsStereoInformation = true;
    }

    private void setSnPositionFuncGroup(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", node.getText());
        this.setLipidLevel(LipidLevel.SN_POSITION);
    }

    private void setCycle(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", "cy");
        this.currentFas.add(new Cycle(0, this.knownFunctionalGroups));
        String fa_i = this.faI();
        this.tmp.put(fa_i, new Dictionary());
        ((Dictionary)this.tmp.get(fa_i)).put("cycle_elements", new GenericList());
    }

    private void addCycle(TreeNode node) {
        String fa_i = this.faI();
        GenericList cycle_elements = (GenericList)((Dictionary)this.tmp.get(fa_i)).get("cycle_elements");
        Cycle cycle = (Cycle)this.currentFas.pollLast();
        for (int i = 0; i < cycle_elements.size(); ++i) {
            cycle.getBridgeChain().add((Element)((Object)cycle_elements.get(i)));
        }
        ((Dictionary)this.tmp.get(fa_i)).remove("cycle_elements");
        if (cycle.getStart() > -1 && cycle.getEnd() > -1 && cycle.getEnd() - cycle.getStart() + 1 + cycle.getBridgeChain().size() < cycle.getCycle()) {
            throw new ConstraintViolationException("Cycle length '" + Integer.toString(cycle.getCycle()) + "' does not match with cycle description.");
        }
        if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey("cy")) {
            this.currentFas.peekLast().getFunctionalGroupsInternal().put("cy", new ArrayList());
        }
        this.currentFas.peekLast().getFunctionalGroupsInternal().get("cy").add(cycle);
    }

    private void setCycleStart(TreeNode node) {
        ((Cycle)this.currentFas.peekLast()).setStart(Integer.valueOf(node.getText()));
    }

    private void setCycleEnd(TreeNode node) {
        ((Cycle)this.currentFas.peekLast()).setEnd(Integer.valueOf(node.getText()));
    }

    private void setCycleNumber(TreeNode node) {
        ((Cycle)this.currentFas.peekLast()).setCycle(Integer.valueOf(node.getText()));
    }

    private void setCycleDbCount(TreeNode node) {
        ((Cycle)this.currentFas.peekLast()).getDoubleBonds().setNumDoubleBonds(Integer.valueOf(node.getText()));
    }

    private void setCycleDbPositions(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("cycle_db", ((Cycle)this.currentFas.peekLast()).getDoubleBonds().getNumDoubleBonds());
    }

    private void checkCycleDbPositions(TreeNode node) {
        if (((Cycle)this.currentFas.peekLast()).getDoubleBonds().getNumDoubleBonds() != ((Integer)((Dictionary)this.tmp.get(this.faI())).get("cycle_db")).intValue()) {
            throw new LipidException("Double bond number in cycle does not correspond to number of double bond positions.");
        }
    }

    private void setCycleDbPosition(TreeNode node) {
        int pos = Integer.valueOf(node.getText());
        ((Cycle)this.currentFas.peekLast()).getDoubleBonds().getDoubleBondPositions().put(pos, "");
        ((Dictionary)this.tmp.get(this.faI())).put("last_db_pos", pos);
    }

    private void setCycleDbPositionCistrans(TreeNode node) {
        int pos = (Integer)((Dictionary)this.tmp.get(this.faI())).get("last_db_pos");
        ((Cycle)this.currentFas.peekLast()).getDoubleBonds().getDoubleBondPositions().put(pos, node.getText());
    }

    private void addCycleElement(TreeNode node) {
        String element = node.getText();
        if (!Elements.ELEMENT_POSITIONS.containsKey(element)) {
            throw new LipidParsingException("Element '" + element + "' unknown");
        }
        ((GenericList)((Dictionary)this.tmp.get(this.faI())).get("cycle_elements")).add(Elements.ELEMENT_POSITIONS.get(element));
    }

    private void setAcylLinkage(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", "acyl");
        this.currentFas.add(new AcylAlkylGroup((FattyAcid)null, this.knownFunctionalGroups));
        this.tmp.put(this.faI(), new Dictionary());
        ((Dictionary)this.tmp.get(this.faI())).put("linkage_pos", -1);
    }

    private void addAcylLinkage(TreeNode node) {
        boolean linkage_type = (Integer)((Dictionary)this.tmp.get(this.faI())).get("linkage_type") == 1;
        int linkage_pos = (Integer)((Dictionary)this.tmp.get(this.faI())).get("linkage_pos");
        this.tmp.remove(this.faI());
        AcylAlkylGroup acyl = (AcylAlkylGroup)this.currentFas.pollLast();
        acyl.setPosition(linkage_pos);
        acyl.setNitrogenBond(linkage_type);
        if (linkage_pos == -1) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey("acyl")) {
            this.currentFas.peekLast().getFunctionalGroupsInternal().put("acyl", new ArrayList());
        }
        this.currentFas.peekLast().getFunctionalGroupsInternal().get("acyl").add(acyl);
    }

    private void setAlkylLinkage(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", "alkyl");
        this.currentFas.add(new AcylAlkylGroup(null, -1, 1, true, this.knownFunctionalGroups));
        this.tmp.put(this.faI(), new Dictionary());
        ((Dictionary)this.tmp.get(this.faI())).put("linkage_pos", -1);
    }

    private void addAlkylLinkage(TreeNode node) {
        int linkage_pos = (Integer)((Dictionary)this.tmp.get(this.faI())).get("linkage_pos");
        this.tmp.remove(this.faI());
        AcylAlkylGroup alkyl = (AcylAlkylGroup)this.currentFas.pollLast();
        alkyl.setPosition(linkage_pos);
        if (linkage_pos == -1) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey("alkyl")) {
            this.currentFas.peekLast().getFunctionalGroupsInternal().put("alkyl", new ArrayList());
        }
        this.currentFas.peekLast().getFunctionalGroupsInternal().get("alkyl").add(alkyl);
    }

    private void setFattyLinkageNumber(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("linkage_pos", Integer.valueOf(node.getText()));
    }

    private void setLinkageType(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("linkage_type", node.getText().equals("N") ? 1 : 0);
    }

    private void setHydrocarbonChain(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", "cc");
        this.currentFas.add(new CarbonChain((FattyAcid)null, this.knownFunctionalGroups));
        this.tmp.put(this.faI(), new Dictionary());
        ((Dictionary)this.tmp.get(this.faI())).put("linkage_pos", -1);
    }

    private void addHydrocarbonChain(TreeNode node) {
        int linkage_pos = (Integer)((Dictionary)this.tmp.get(this.faI())).get("linkage_pos");
        this.tmp.remove(this.faI());
        CarbonChain cc = (CarbonChain)this.currentFas.pollLast();
        cc.setPosition(linkage_pos);
        if (linkage_pos == -1) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        if (!this.currentFas.peekLast().getFunctionalGroupsInternal().containsKey("cc")) {
            this.currentFas.peekLast().getFunctionalGroupsInternal().put("cc", new ArrayList());
        }
        this.currentFas.peekLast().getFunctionalGroupsInternal().get("cc").add(cc);
    }

    private void setRingStereo(TreeNode node) {
        ((Dictionary)this.tmp.get(this.faI())).put("fg_ring_stereo", node.getText());
    }

    private void setHgAcyl(TreeNode node) {
        String fa_i = this.faI();
        this.tmp.put(fa_i, new Dictionary());
        ((Dictionary)this.tmp.get(fa_i)).put("fg_name", "decorator_acyl");
        this.currentFas.add(new HeadgroupDecorator("decorator_acyl", -1, 1, null, true, this.knownFunctionalGroups));
        this.tmp.put(this.faI(), new Dictionary());
    }

    private void addHgAcyl(TreeNode node) {
        this.tmp.remove(this.faI());
        this.headgroupDecorators.add((HeadgroupDecorator)this.currentFas.pollLast());
        this.tmp.remove(this.faI());
    }

    private void setHgAlkyl(TreeNode node) {
        this.tmp.put(this.faI(), new Dictionary());
        ((Dictionary)this.tmp.get(this.faI())).put("fg_name", "decorator_alkyl");
        this.currentFas.add(new HeadgroupDecorator("decorator_alkyl", -1, 1, null, true, this.knownFunctionalGroups));
        this.tmp.put(this.faI(), new Dictionary());
    }

    private void addHgAlkyl(TreeNode node) {
        this.tmp.remove(this.faI());
        this.headgroupDecorators.add((HeadgroupDecorator)this.currentFas.pollLast());
        this.tmp.remove(this.faI());
    }

    private void addPlSpeciesData(TreeNode node) {
        this.setLipidLevel(LipidLevel.SPECIES);
        HeadgroupDecorator hgd = new HeadgroupDecorator("", this.knownFunctionalGroups);
        hgd.getElements().put(Element.O, (Integer)hgd.getElements().get((Object)Element.O) + 1);
        hgd.getElements().put(Element.H, (Integer)hgd.getElements().get((Object)Element.H) - 1);
        this.headgroupDecorators.add(hgd);
    }

    private void suffixDecoratorMolecular(TreeNode node) {
        this.headgroupDecorators.add(new HeadgroupDecorator(node.getText(), -1, 1, null, true, LipidLevel.MOLECULAR_SPECIES, this.knownFunctionalGroups));
    }

    private void suffixDecoratorSpecies(TreeNode node) {
        this.headgroupDecorators.add(new HeadgroupDecorator(node.getText(), -1, 1, null, true, LipidLevel.SPECIES, this.knownFunctionalGroups));
    }

    private void setAcer(TreeNode node) {
        this.headGroup = "ACer";
        HeadgroupDecorator hgd = new HeadgroupDecorator("decorator_acyl", -1, 1, null, true, this.knownFunctionalGroups);
        hgd.getFunctionalGroupsInternal().put("decorator_acyl", new ArrayList());
        hgd.getFunctionalGroupsInternal().get("decorator_acyl").add((FunctionalGroup)this.faList.get(this.faList.size() - 1));
        this.faList.remove(this.faList.size() - 1);
        this.headgroupDecorators.add(hgd);
    }

    private void setAcerSpecies(TreeNode node) {
        this.headGroup = "ACer";
        this.setLipidLevel(LipidLevel.SPECIES);
        HeadgroupDecorator hgd = new HeadgroupDecorator("decorator_acyl", -1, 1, null, true, this.knownFunctionalGroups);
        hgd.getFunctionalGroupsInternal().put("decorator_acyl", new ArrayList());
        hgd.getFunctionalGroupsInternal().get("decorator_acyl").add(new FattyAcid("FA", 2, this.knownFunctionalGroups));
        this.headgroupDecorators.add(hgd);
        this.acerSpecies = true;
    }
}

