/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.StringFunctions;
import org.lifstools.jgoslin.parser.SumFormulaParser;
import org.lifstools.jgoslin.parser.SumFormulaParserEventHandler;
import org.springframework.core.io.ClassPathResource;

public final class LipidClasses
extends ArrayList<LipidClassMeta> {
    private static final LipidClasses LIPID_CLASSES = new LipidClasses();
    public static final int UNDEFINED_CLASS = 0;

    private LipidClasses() {
        this.loadData(StringFunctions.getResourceAsStringList(new ClassPathResource("lipid-list.csv")), new SumFormulaParser());
    }

    private void loadData(List<String> lines, SumFormulaParser sfp) {
        this.add(new LipidClassMeta(LipidCategory.NO_CATEGORY, "UNDEFINED", "", 0, 0, new HashSet<String>(), new ElementTable(), new ArrayList<String>(Arrays.asList("UNDEFINED"))));
        int lineCounter = 0;
        int SYNONYM_START_INDEX = 7;
        HashMap<Object, ArrayList<String>> data = new HashMap<Object, ArrayList<String>>();
        HashSet<String> keys = new HashSet<String>();
        HashMap<Object, Integer> enum_names = new HashMap<Object, Integer>(Map.ofEntries(Map.entry("GL", 1), Map.entry("GP", 1), Map.entry("SP", 1), Map.entry("ST", 1), Map.entry("FA", 1), Map.entry("PK", 1), Map.entry("SL", 1), Map.entry("UNDEFINED", 1)));
        Map names_to_category = Map.ofEntries(Map.entry("GL", LipidCategory.GL), Map.entry("GP", LipidCategory.GP), Map.entry("SP", LipidCategory.SP), Map.entry("ST", LipidCategory.ST), Map.entry("FA", LipidCategory.FA), Map.entry("PK", LipidCategory.PK), Map.entry("SL", LipidCategory.SL), Map.entry("UNDEFINED", LipidCategory.UNDEFINED));
        for (String line : lines) {
            if (lineCounter++ == 0) continue;
            ArrayList<String> tokens = StringFunctions.splitString(line, ',', '\"', true);
            if (keys.contains(tokens.get(0))) {
                throw new ConstraintViolationException("Error: lipid name '" + tokens.get(0) + "' occurs multiple times in the lipid list.");
            }
            keys.add(tokens.get(0));
            for (int i = SYNONYM_START_INDEX; i < tokens.size(); ++i) {
                String test_lipid_name = tokens.get(i);
                if (test_lipid_name.length() == 0) continue;
                if (keys.contains(test_lipid_name)) {
                    throw new ConstraintViolationException("Error: lipid name '" + test_lipid_name + "' occurs multiple times in the lipid list.");
                }
                keys.add(test_lipid_name);
            }
            Object enum_name = tokens.get(0);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((String)enum_name).length(); ++i) {
                char c = ((String)enum_name).charAt(i);
                if ('A' <= c && c <= 'Z') {
                    sb.append(c);
                    continue;
                }
                if ('0' <= c && c <= '9') {
                    sb.append(c);
                    continue;
                }
                if ('a' <= c && c <= 'z') {
                    sb.append(Character.toString(c - 32));
                    continue;
                }
                sb.append('_');
            }
            enum_name = sb.toString();
            if (((String)enum_name).charAt(0) == '_') {
                enum_name = "L" + (String)enum_name;
            }
            if (((String)enum_name).charAt(0) < 'A' || 'Z' < ((String)enum_name).charAt(0)) {
                enum_name = "L" + (String)enum_name;
            }
            if (!enum_names.containsKey(enum_name)) {
                enum_names.put(enum_name, 1);
            } else {
                int cnt = (Integer)enum_names.get(enum_name) + 1;
                enum_names.put(enum_name, cnt);
                enum_name = (String)enum_name + (65 + cnt - 1);
                enum_names.put(enum_name, 1);
            }
            data.put(enum_name, tokens);
        }
        SumFormulaParserEventHandler handler = sfp.newEventHandler();
        data.entrySet().forEach((? super T kv) -> {
            HashSet<String> special_cases = new HashSet<String>();
            StringFunctions.splitString((String)((ArrayList)kv.getValue()).get(5), ';', '\"').forEach((? super E scase) -> special_cases.add(StringFunctions.strip(scase, '\"')));
            ElementTable e = ((String)((ArrayList)kv.getValue()).get(6)).length() > 0 ? (ElementTable)sfp.parse((String)((ArrayList)kv.getValue()).get(6), handler) : new ElementTable();
            ArrayList<String> synonyms = new ArrayList<String>();
            synonyms.add((String)((ArrayList)kv.getValue()).get(0));
            for (int ii = SYNONYM_START_INDEX; ii < ((ArrayList)kv.getValue()).size(); ++ii) {
                if (((String)((ArrayList)kv.getValue()).get(ii)).length() <= 0) continue;
                synonyms.add(StringFunctions.strip((String)((ArrayList)kv.getValue()).get(ii), '\"'));
            }
            this.add(new LipidClassMeta((LipidCategory)((Object)((Object)names_to_category.get(((ArrayList)kv.getValue()).get(1)))), (String)((ArrayList)kv.getValue()).get(0), (String)((ArrayList)kv.getValue()).get(2), Integer.valueOf((String)((ArrayList)kv.getValue()).get(3)), Integer.valueOf((String)((ArrayList)kv.getValue()).get(4)), special_cases, e, synonyms));
        });
    }

    public static LipidClasses getInstance() {
        return LIPID_CLASSES;
    }
}

