/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.Collection;
import java.util.Collections;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidFullStructure;
import org.lifstools.jgoslin.domain.LipidLevel;

public class LipidCompleteStructure
extends LipidFullStructure {
    public LipidCompleteStructure(Headgroup _headgroup, KnownFunctionalGroups knownFunctionalGroups) {
        this(_headgroup, Collections.emptyList(), knownFunctionalGroups);
    }

    public LipidCompleteStructure(Headgroup _headgroup, Collection<FattyAcid> _fa, KnownFunctionalGroups knownFunctionalGroups) {
        super(_headgroup, _fa, knownFunctionalGroups);
        this.info.setLevel(LipidLevel.COMPLETE_STRUCTURE);
    }

    @Override
    public LipidLevel getLipidLevel() {
        return LipidLevel.COMPLETE_STRUCTURE;
    }

    @Override
    public String getLipidString() {
        return this.getLipidString(LipidLevel.NO_LEVEL);
    }

    @Override
    public String getLipidString(LipidLevel level) {
        switch (level) {
            case NO_LEVEL: 
            case COMPLETE_STRUCTURE: {
                return super.buildLipidSubspeciesName(LipidLevel.COMPLETE_STRUCTURE);
            }
            case FULL_STRUCTURE: 
            case STRUCTURE_DEFINED: 
            case SN_POSITION: 
            case MOLECULAR_SPECIES: 
            case SPECIES: 
            case CATEGORY: 
            case CLASS: {
                return super.getLipidString(level);
            }
        }
        throw new IllegalArgumentException("LipidCompleteStructure does not know how to create a lipid string for level " + level.toString());
    }
}

