/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Cycle;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.parser.LipidBaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class LipidMapsParserEventHandler
extends LipidBaseParserEventHandler {
    private boolean omitFa;
    private int dbNumbers;
    private int dbPosition;
    private String dbCistrans;
    private String modText;
    private int modPos;
    private int modNum;
    private boolean addOmegaLinoleoyloxyCer;
    private static final Set<String> HEAD_GROUP_EXCEPTIONS = Set.of("PA", "PC", "PE", "PG", "PI", "PS");
    private static final Map<String, Integer> ACER_HEADS = Map.ofEntries(Map.entry("1-O-myristoyl", 14), Map.entry("1-O-palmitoyl", 16), Map.entry("1-O-stearoyl", 18), Map.entry("1-O-eicosanoyl", 20), Map.entry("1-O-behenoyl", 22), Map.entry("1-O-lignoceroyl", 24), Map.entry("1-O-cerotoyl", 26), Map.entry("1-O-pentacosanoyl", 25), Map.entry("1-O-carboceroyl", 28), Map.entry("1-O-tricosanoyl", 30), Map.entry("1-O-lignoceroyl-omega-linoleoyloxy", 24), Map.entry("1-O-stearoyl-omega-linoleoyloxy", 18));

    public LipidMapsParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        super(knownFunctionalGroups);
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("lipid_pre_event", this::resetParser), Map.entry("lipid_post_event", this::buildLipid), Map.entry("adduct_info_pre_event", this::newAdduct), Map.entry("adduct_pre_event", this::addAdduct), Map.entry("charge_pre_event", this::addCharge), Map.entry("charge_sign_pre_event", this::addChargeSign), Map.entry("mediator_pre_event", this::mediatorEvent), Map.entry("sgl_species_pre_event", this::setSpeciesLevel), Map.entry("species_fa_pre_event", this::setSpeciesLevel), Map.entry("tgl_species_pre_event", this::setSpeciesLevel), Map.entry("dpl_species_pre_event", this::setSpeciesLevel), Map.entry("cl_species_pre_event", this::setSpeciesLevel), Map.entry("dsl_species_pre_event", this::setSpeciesLevel), Map.entry("fa2_unsorted_pre_event", this::setMolecularSubspeciesLevel), Map.entry("fa3_unsorted_pre_event", this::setMolecularSubspeciesLevel), Map.entry("fa4_unsorted_pre_event", this::setMolecularSubspeciesLevel), Map.entry("hg_dg_pre_event", this::setMolecularSubspeciesLevel), Map.entry("fa_lpl_molecular_pre_event", this::setMolecularSubspeciesLevel), Map.entry("hg_lbpa_pre_event", this::setMolecularSubspeciesLevel), Map.entry("fa_no_hg_pre_event", this::pureFa), Map.entry("hg_sgl_pre_event", this::setHeadGroupName), Map.entry("hg_gl_pre_event", this::setHeadGroupName), Map.entry("hg_cl_pre_event", this::setHeadGroupName), Map.entry("hg_dpl_pre_event", this::setHeadGroupName), Map.entry("hg_lpl_pre_event", this::setHeadGroupName), Map.entry("hg_threepl_pre_event", this::setHeadGroupName), Map.entry("hg_fourpl_pre_event", this::setHeadGroupName), Map.entry("hg_dsl_pre_event", this::setHeadGroupName), Map.entry("hg_cpa_pre_event", this::setHeadGroupName), Map.entry("ch_pre_event", this::setHeadGroupName), Map.entry("hg_che_pre_event", this::setHeadGroupName), Map.entry("mediator_const_pre_event", this::setHeadGroupName), Map.entry("pk_hg_pre_event", this::setHeadGroupName), Map.entry("hg_fa_pre_event", this::setHeadGroupName), Map.entry("hg_lsl_pre_event", this::setHeadGroupName), Map.entry("special_cer_pre_event", this::setHeadGroupName), Map.entry("special_cer_hg_pre_event", this::setHeadGroupName), Map.entry("omega_linoleoyloxy_Cer_pre_event", this::setOmegaHeadGroupName), Map.entry("lcb_pre_event", this::newLcb), Map.entry("lcb_post_event", this::cleanLcb), Map.entry("fa_pre_event", this::newFa), Map.entry("fa_post_event", this::appendFa), Map.entry("glyco_struct_pre_event", this::addGlyco), Map.entry("db_single_position_pre_event", this::setIsomericLevel), Map.entry("db_single_position_post_event", this::addDbPosition), Map.entry("db_position_number_pre_event", this::addDbPositionNumber), Map.entry("cistrans_pre_event", this::addCistrans), Map.entry("ether_pre_event", this::addEther), Map.entry("hydroxyl_pre_event", this::addHydroxyl), Map.entry("hydroxyl_lcb_pre_event", this::addHydroxylLcb), Map.entry("db_count_pre_event", this::addDoubleBonds), Map.entry("carbon_pre_event", this::addCarbon), Map.entry("structural_mod_pre_event", this::setStructuralSubspeciesLevel), Map.entry("single_mod_pre_event", this::setMod), Map.entry("mod_text_pre_event", this::setModText), Map.entry("mod_pos_pre_event", this::setModPos), Map.entry("mod_num_pre_event", this::setModNum), Map.entry("single_mod_post_event", this::addFunctionalGroup), Map.entry("special_cer_prefix_pre_event", this::addAcer));
        }
        catch (Exception e) {
            throw new LipidParsingException("Cannot initialize LipidMapsParserEventHandler.");
        }
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = null;
        this.level = LipidLevel.FULL_STRUCTURE;
        this.headGroup = "";
        this.lcb = null;
        this.adduct = null;
        this.faList.clear();
        this.currentFa = null;
        this.useHeadGroup = false;
        this.omitFa = false;
        this.dbPosition = 0;
        this.dbNumbers = -1;
        this.dbCistrans = "";
        this.modPos = -1;
        this.modNum = 1;
        this.modText = "";
        this.headgroupDecorators.clear();
        this.addOmegaLinoleoyloxyCer = false;
    }

    private void addAcer(TreeNode node) {
        String head = node.getText();
        this.headGroup = "ACer";
        if (!ACER_HEADS.containsKey(head)) {
            throw new LipidException("ACer head group '" + head + "' unknown");
        }
        HeadgroupDecorator hgd = new HeadgroupDecorator("decorator_acyl", -1, 1, null, true, this.knownFunctionalGroups);
        int acer_num = ACER_HEADS.get(head);
        hgd.getFunctionalGroupsInternal().put("decorator_acyl", new ArrayList());
        hgd.getFunctionalGroupsInternal().get("decorator_acyl").add(new FattyAcid("FA", acer_num, this.knownFunctionalGroups));
        this.headgroupDecorators.add(hgd);
        if (head.equals("1-O-lignoceroyl-omega-linoleoyloxy") || head.equals("1-O-stearoyl-omega-linoleoyloxy")) {
            this.addOmegaLinoleoyloxyCer = true;
        }
    }

    private void setMolecularSubspeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
    }

    private void pureFa(TreeNode node) {
        this.headGroup = "FA";
    }

    private void mediatorEvent(TreeNode node) {
        this.useHeadGroup = true;
        this.headGroup = node.getText();
    }

    private void setIsomericLevel(TreeNode node) {
        this.dbPosition = 0;
        this.dbCistrans = "";
    }

    private void addDbPosition(TreeNode node) {
        if (this.currentFa != null) {
            this.currentFa.getDoubleBonds().getDoubleBondPositions().put(this.dbPosition, this.dbCistrans);
            if (!this.dbCistrans.equals("E") && !this.dbCistrans.equals("Z")) {
                this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
            }
        }
    }

    private void setOmegaHeadGroupName(TreeNode node) {
        this.addOmegaLinoleoyloxyCer = true;
        this.setHeadGroupName(node);
    }

    private void addGlyco(TreeNode node) {
        String glyco_name = node.getText();
        HeadgroupDecorator functional_group = null;
        try {
            functional_group = (HeadgroupDecorator)this.knownFunctionalGroups.get(glyco_name);
        }
        catch (Exception e) {
            throw new LipidParsingException("Carbohydrate '" + glyco_name + "' unknown");
        }
        functional_group.getElements().put(Element.O, (Integer)functional_group.getElements().get((Object)Element.O) - 1);
        this.headgroupDecorators.add(functional_group);
    }

    private void addDbPositionNumber(TreeNode node) {
        this.dbPosition = Integer.valueOf(node.getText());
    }

    private void addCistrans(TreeNode node) {
        this.dbCistrans = node.getText();
    }

    private void setHeadGroupName(TreeNode node) {
        this.headGroup = node.getText();
    }

    private void setSpeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.SPECIES);
    }

    private void setStructuralSubspeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
    }

    private void setMod(TreeNode node) {
        this.modText = "";
        this.modPos = -1;
        this.modNum = 1;
    }

    private void setModText(TreeNode node) {
        this.modText = node.getText();
    }

    private void setModPos(TreeNode node) {
        this.modPos = node.getInt();
    }

    private void setModNum(TreeNode node) {
        this.modNum = node.getInt();
    }

    private void addFunctionalGroup(TreeNode node) {
        if (!this.modText.equals("Cp")) {
            FunctionalGroup functional_group = this.knownFunctionalGroups.get(this.modText);
            functional_group.setPosition(this.modPos);
            functional_group.setCount(this.modNum);
            String fg_name = functional_group.getName();
            if (!this.currentFa.getFunctionalGroupsInternal().containsKey(fg_name)) {
                this.currentFa.getFunctionalGroupsInternal().put(fg_name, new ArrayList());
            }
            this.currentFa.getFunctionalGroupsInternal().get(fg_name).add(functional_group);
        } else {
            this.currentFa.setNumCarbon(this.currentFa.getNumCarbon() + 1);
            Cycle cycle = new Cycle(3, this.modPos, this.modPos + 2, this.knownFunctionalGroups);
            if (!this.currentFa.getFunctionalGroupsInternal().containsKey("cy")) {
                this.currentFa.getFunctionalGroupsInternal().put("cy", new ArrayList());
            }
            this.currentFa.getFunctionalGroupsInternal().get("cy").add(cycle);
        }
    }

    private void newFa(TreeNode node) {
        this.dbNumbers = -1;
        this.currentFa = new FattyAcid("FA", this.knownFunctionalGroups);
    }

    private void newLcb(TreeNode node) {
        this.lcb = new FattyAcid("LCB", this.knownFunctionalGroups);
        this.lcb.setType(LipidFaBondType.LCB_REGULAR);
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        this.currentFa = this.lcb;
    }

    private void cleanLcb(TreeNode node) {
        if (this.dbNumbers > -1 && this.dbNumbers != this.currentFa.getDoubleBonds().getNumDoubleBonds()) {
            throw new LipidException("Double bond count does not match with number of double bond positions");
        }
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        this.currentFa = null;
    }

    private void appendFa(TreeNode node) {
        if (this.dbNumbers > -1 && this.dbNumbers != this.currentFa.getDoubleBonds().getNumDoubleBonds()) {
            throw new LipidException("Double bond count does not match with number of double bond positions");
        }
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        if (this.currentFa.getNumCarbon() == 0) {
            this.omitFa = true;
        }
        this.faList.add(this.currentFa);
        this.currentFa = null;
    }

    private void addEther(TreeNode node) {
        String ether = node.getText();
        if (ether.equals("O-")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMANYL);
        } else if (ether.equals("P-")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMENYL);
        }
    }

    private void addHydroxyl(TreeNode node) {
        int num_h = node.getInt();
        if (this.spRegularLcb()) {
            --num_h;
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
        functional_group.setCount(num_h);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
            this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
    }

    private void addHydroxylLcb(TreeNode node) {
        String hydroxyl = node.getText();
        int num_h = 0;
        if (hydroxyl.equals("m")) {
            num_h = 1;
        } else if (hydroxyl.equals("d")) {
            num_h = 2;
        } else if (hydroxyl.equals("t")) {
            num_h = 3;
        }
        if (this.spRegularLcb()) {
            --num_h;
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
        functional_group.setCount(num_h);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
            this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
    }

    private void addDoubleBonds(TreeNode node) {
        this.currentFa.getDoubleBonds().setNumDoubleBonds(this.currentFa.getDoubleBonds().getNumDoubleBonds() + node.getInt());
    }

    private void addCarbon(TreeNode node) {
        this.currentFa.setNumCarbon(node.getInt());
    }

    private void buildLipid(TreeNode node) {
        if (this.omitFa && HEAD_GROUP_EXCEPTIONS.contains(this.headGroup)) {
            this.headGroup = "L" + this.headGroup;
        }
        if (this.lcb != null) {
            this.faList.add(0, this.lcb);
        }
        if (this.addOmegaLinoleoyloxyCer) {
            if (this.faList.size() != 2) {
                throw new ConstraintViolationException("omega-linoleoyloxy-Cer with a different combination to one long chain base and one fatty acyl chain unknown");
            }
            Map<String, ArrayList<FunctionalGroup>> fgroups = ((FattyAcid)this.faList.get(this.faList.size() - 1)).getFunctionalGroupsInternal();
            if (!fgroups.containsKey("acyl")) {
                fgroups.put("acyl", new ArrayList());
            }
            DoubleBonds db = new DoubleBonds(2);
            db.getDoubleBondPositions().put(9, "Z");
            db.getDoubleBondPositions().put(12, "Z");
            ((FattyAcid)this.faList.get(this.faList.size() - 1)).getFunctionalGroupsInternal().get("acyl").add(new FattyAcid("FA", 18, db));
            this.headGroup = "Cer";
        }
        Headgroup headgroup = this.prepareHeadgroupAndChecks();
        this.content = new LipidAdduct(this.assembleLipid(headgroup), this.adduct);
    }

    private void newAdduct(TreeNode node) {
        this.adduct = new Adduct("", "");
    }

    private void addAdduct(TreeNode node) {
        this.adduct.setAdductString(node.getText());
    }

    private void addCharge(TreeNode node) {
        this.adduct.setCharge(Integer.valueOf(node.getText()));
    }

    private void addChargeSign(TreeNode node) {
        String sign = node.getText();
        if (sign.equals("+")) {
            this.adduct.setChargeSign(1);
        } else if (sign.equals("-")) {
            this.adduct.setChargeSign(-1);
        }
    }
}

