/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.domain.StringFunctions;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;
import org.lifstools.jgoslin.parser.FattyAcidParser;
import org.lifstools.jgoslin.parser.GoslinParser;
import org.lifstools.jgoslin.parser.HmdbParser;
import org.lifstools.jgoslin.parser.LipidMapsParser;
import org.lifstools.jgoslin.parser.Parser;
import org.lifstools.jgoslin.parser.ShorthandParser;
import org.lifstools.jgoslin.parser.SumFormulaParser;
import org.lifstools.jgoslin.parser.SwissLipidsParser;
import org.springframework.core.io.ClassPathResource;

public class LipidParser {
    private final List<Parser<LipidAdduct>> parserList;
    private Parser<LipidAdduct> lastSuccessfulParser = null;

    private LipidParser(Parser<LipidAdduct> ... parsers) {
        this.parserList = Arrays.asList(parsers);
    }

    public LipidParser() {
        this(new KnownFunctionalGroups(StringFunctions.getResourceAsStringList(new ClassPathResource("functional-groups.csv")), new SumFormulaParser()));
    }

    public LipidParser(KnownFunctionalGroups knownFunctionalGroups) {
        this(new ShorthandParser(knownFunctionalGroups), new FattyAcidParser(knownFunctionalGroups), new GoslinParser(knownFunctionalGroups), new LipidMapsParser(knownFunctionalGroups), new SwissLipidsParser(knownFunctionalGroups), new HmdbParser(knownFunctionalGroups));
    }

    public LipidAdduct parse(String lipidName) {
        this.lastSuccessfulParser = null;
        Parser<LipidAdduct> lastParser = null;
        BaseParserEventHandler<LipidAdduct> eventHandler = null;
        Iterator<Parser<LipidAdduct>> iterator = this.parserList.iterator();
        while (iterator.hasNext()) {
            Parser<LipidAdduct> parser;
            lastParser = parser = iterator.next();
            eventHandler = parser.newEventHandler();
            LipidAdduct lipid = parser.parse(lipidName, eventHandler, false);
            if (lipid == null) continue;
            this.lastSuccessfulParser = parser;
            return lipid;
        }
        Object message = " Parsing failed ";
        if (eventHandler == null) {
            message = (String)message + " with unknown reason.";
        } else {
            String errorMessage = eventHandler.errorMessage;
            if (errorMessage == null || errorMessage.isEmpty()) {
                errorMessage = lipidName;
            }
            message = (String)message + "at or after " + errorMessage;
        }
        throw new LipidParsingException("Could not parse lipid '" + lipidName + "' with any parser!" + (String)message);
    }

    public Parser<LipidAdduct> getLastSuccessfulParser() {
        return this.lastSuccessfulParser;
    }
}

